/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.mbean.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.mbean.config.MBeanFileConfig;
import org.tinygroup.mbean.config.TinyModeInfo;
import org.tinygroup.mbean.config.TinyModeInfos;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class MBeanFileProcessor
extends MBeanFileConfig
implements FileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanFileProcessor.class);
    private static final String MBEAN_FILENAME = ".mbean.xml";
    private List<TinyModeInfo> list = new ArrayList<TinyModeInfo>();

    @Override
    protected List<TinyModeInfo> getTinyModeInfos() {
        return this.list;
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(MBEAN_FILENAME);
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"mbean");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664MBean\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            TinyModeInfos info = (TinyModeInfos)this.caches.get(fileObject.getAbsolutePath());
            if (info != null) {
                this.list.remove(info);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664MBean\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u8bfb\u53d6MBean\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            TinyModeInfos oldModeList = (TinyModeInfos)this.caches.get(fileObject.getAbsolutePath());
            if (oldModeList != null) {
                this.caches.remove(fileObject.getAbsolutePath());
            }
            InputStream inputStream = fileObject.getInputStream();
            TinyModeInfos modeList = (TinyModeInfos)stream.fromXML(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            if (modeList != null && !modeList.getModeList().isEmpty()) {
                for (TinyModeInfo info : modeList.getModeList()) {
                    this.list.add(info);
                }
            }
            this.caches.put(fileObject.getAbsolutePath(), modeList);
            LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6MBean\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        try {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u6ce8\u518cMBean");
            this.loadMBeanServer(this.getFileResolver().getClassLoader());
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u6ce8\u518cMBean\u7ed3\u675f");
        }
        catch (Exception e) {
            LOGGER.errorMessage("\u6ce8\u518cMBean\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        this.list.clear();
    }
}

