/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.mbean.config;

import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.mbean.config.TinyModeInfo;

public abstract class MBeanFileConfig
extends AbstractFileProcessor {
    protected static final String MBEAN_XSTREAM_PACKAGENAME = "mbean";
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanFileConfig.class);

    public void loadMBeanServer(ClassLoader classLoader) throws Exception {
        List<TinyModeInfo> list = this.getTinyModeInfos();
        if (list.isEmpty()) {
            return;
        }
        MBeanServer mb = ManagementFactory.getPlatformMBeanServer();
        for (TinyModeInfo info : list) {
            ObjectName name = new ObjectName("TinyMBean:name=" + info.getTinyModeName());
            Object object = null;
            object = "bean".equals(info.getFrom()) ? BeanContainerFactory.getBeanContainer((ClassLoader)classLoader).getBean(info.getValue()) : (Object)Class.forName(info.getValue()).newInstance();
            mb.registerMBean(object, name);
            LOGGER.logMessage(LogLevel.INFO, "MBean\u670d\u52a1[{0}]\u6ce8\u518c\u6210\u529f", new Object[]{info.getTinyModeName()});
        }
    }

    protected abstract List<TinyModeInfo> getTinyModeInfos();
}

