/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.message;

import java.util.Collection;
import java.util.List;
import org.tinygroup.message.Message;
import org.tinygroup.message.MessageAccount;
import org.tinygroup.message.MessageException;
import org.tinygroup.message.MessageManager;
import org.tinygroup.message.MessageReceiveProcessor;
import org.tinygroup.message.MessageReceiveService;
import org.tinygroup.message.MessageReceiver;
import org.tinygroup.message.MessageSendProcessor;
import org.tinygroup.message.MessageSendService;
import org.tinygroup.message.MessageSender;

public class MessageManagerDefault<Account extends MessageAccount, Sender extends MessageSender, Receiver extends MessageReceiver, Msg extends Message>
implements MessageManager<Account, Sender, Receiver, Msg> {
    private Account messageAccount;
    private MessageReceiveService<Account, Msg> messageReceiveService;
    private MessageSendService<Account, Sender, Receiver, Msg> messageSendService;
    private List<MessageReceiveProcessor<Msg>> messageReceiveProcessors;
    private List<MessageSendProcessor<Sender, Receiver, Msg>> messageSendProcessors;

    @Override
    public void setMessageAccount(Account messageAccount) {
        this.messageAccount = messageAccount;
    }

    @Override
    public void setMessageReceiveService(MessageReceiveService<Account, Msg> messageReceiveService) {
        this.messageReceiveService = messageReceiveService;
    }

    @Override
    public void setMessageSendService(MessageSendService<Account, Sender, Receiver, Msg> messageSendService) {
        this.messageSendService = messageSendService;
    }

    @Override
    public void setMessageReceiveProcessors(List<MessageReceiveProcessor<Msg>> messageReceiveProcessors) {
        this.messageReceiveProcessors = messageReceiveProcessors;
    }

    @Override
    public void addMessageReceiveProcessor(MessageReceiveProcessor<Msg> messageReceiveProcessor) {
    }

    @Override
    public void setMessageSendProcessors(List<MessageSendProcessor<Sender, Receiver, Msg>> messageSendProcessors) {
        this.messageSendProcessors = messageSendProcessors;
    }

    @Override
    public void addMessageSendProcessor(MessageSendProcessor<Sender, Receiver, Msg> messageSendProcessor) {
    }

    @Override
    public Collection<Msg> getMessages() throws MessageException {
        Collection<Msg> messages = this.messageReceiveService.getMessages(this.messageAccount);
        if (this.messageReceiveProcessors != null && !this.messageReceiveProcessors.isEmpty()) {
            for (Message message : messages) {
                for (MessageReceiveProcessor<Msg> processor : this.messageReceiveProcessors) {
                    if (!processor.isMatch(message)) continue;
                    processor.processMessage(message);
                }
            }
        }
        return messages;
    }

    @Override
    public void sendMessage(Sender messageSender, Collection<Receiver> messageReceivers, Msg message) throws MessageException {
        this.messageSendService.sendMessage(this.messageAccount, messageSender, messageReceivers, message);
        if (this.messageSendProcessors != null && this.messageSendProcessors.size() > 0) {
            for (MessageReceiver receiver : messageReceivers) {
                for (MessageSendProcessor<Sender, Receiver, Msg> msgMessageSendProcessor : this.messageSendProcessors) {
                    if (!msgMessageSendProcessor.isMatch(messageSender, receiver, message)) continue;
                    msgMessageSendProcessor.processMessage(messageSender, receiver, message);
                }
            }
        }
    }
}

