/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.message.email;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.tinygroup.message.MessageException;
import org.tinygroup.message.MessageReceiveService;
import org.tinygroup.message.email.EmailAccessory;
import org.tinygroup.message.email.EmailMessage;
import org.tinygroup.message.email.EmailMessageAccount;
import org.tinygroup.message.email.EmailMessageFlagMarker;
import org.tinygroup.message.email.EmailMessageReceiver;
import org.tinygroup.message.email.EmailMessageSender;
import org.tinygroup.message.email.EmailMessageUtil;
import org.tinygroup.message.email.EmailReceiveMessage;

public class EmailMessageReceiveService
implements MessageReceiveService<EmailMessageAccount, EmailReceiveMessage> {
    private EmailMessageFlagMarker emailMessageFlagMarker;

    public EmailMessageFlagMarker getEmailMessageFlagMarker() {
        return this.emailMessageFlagMarker;
    }

    public void setEmailMessageFlagMarker(EmailMessageFlagMarker emailMessageFlagMarker) {
        this.emailMessageFlagMarker = emailMessageFlagMarker;
    }

    @Override
    public Collection<EmailReceiveMessage> getMessages(EmailMessageAccount messageAccount) throws MessageException {
        try {
            Session session = EmailMessageUtil.getSession(messageAccount);
            Store store = session.getStore("pop3");
            store.connect(messageAccount.getHost(), messageAccount.getUsername(), messageAccount.getPassword());
            Folder folder = store.getFolder("inbox");
            folder.open(2);
            Message[] messages = folder.getMessages();
            ArrayList<EmailReceiveMessage> receiveMessages = new ArrayList<EmailReceiveMessage>();
            for (int i = 0; i < messages.length; ++i) {
                EmailReceiveMessage message = new EmailReceiveMessage();
                receiveMessages.add(message);
                message.setMessage(this.getEmailMessage(messages[i]));
                message.setMessageSenders(this.getMessageSender(messages[i]));
                message.setReceiveDate(messages[i].getReceivedDate());
                message.setSendDate(messages[i].getSentDate());
                message.setMessageReceivers(this.getMessageReceivers(messages[i]));
                if (this.emailMessageFlagMarker == null) continue;
                messages[i].setFlag(this.emailMessageFlagMarker.getFlag(message, messages[i]), true);
            }
            folder.close(true);
            store.close();
            return receiveMessages;
        }
        catch (Exception e) {
            throw new MessageException(e);
        }
    }

    private Collection<EmailMessageReceiver> getMessageReceivers(Message message) throws MessagingException {
        ArrayList<EmailMessageReceiver> receivers = new ArrayList<EmailMessageReceiver>();
        this.addReceivers(receivers, Message.RecipientType.TO, message.getReplyTo());
        this.addReceivers(receivers, Message.RecipientType.TO, message.getRecipients(Message.RecipientType.TO));
        this.addReceivers(receivers, Message.RecipientType.CC, message.getRecipients(Message.RecipientType.CC));
        this.addReceivers(receivers, Message.RecipientType.BCC, message.getRecipients(Message.RecipientType.BCC));
        return receivers;
    }

    private void addReceivers(List<EmailMessageReceiver> receivers, Message.RecipientType type, Address[] replyTo) throws AddressException {
        if (replyTo != null) {
            for (Address address : replyTo) {
                InternetAddress internetAddress = new InternetAddress(address.toString());
                EmailMessageReceiver messageReceiver = new EmailMessageReceiver();
                receivers.add(messageReceiver);
                messageReceiver.setEmail(internetAddress.getAddress());
                messageReceiver.setDisplayName(internetAddress.getPersonal());
                messageReceiver.setType(type);
            }
        }
    }

    private Collection<EmailMessageSender> getMessageSender(Message message) throws MessagingException, IOException {
        Address[] addresses = message.getFrom();
        ArrayList<EmailMessageSender> messageSenders = new ArrayList<EmailMessageSender>();
        for (Address address : addresses) {
            InternetAddress internetAddress = new InternetAddress(address.toString());
            EmailMessageSender messageSender = new EmailMessageSender();
            messageSenders.add(messageSender);
            messageSender.setEmail(internetAddress.getAddress());
            messageSender.setDisplayName(internetAddress.getPersonal());
        }
        return messageSenders;
    }

    private EmailMessage getEmailMessage(Message message) throws MessagingException, IOException, MessageException {
        EmailMessage emailMessage = new EmailMessage();
        emailMessage.setSubject(message.getSubject());
        this.getContent(emailMessage, (Part)message);
        return emailMessage;
    }

    private void getContent(EmailMessage emailMessage, Part part) throws MessagingException, IOException, MessageException {
        String contentType = part.getContentType();
        int nameIndex = contentType.indexOf("name");
        if (nameIndex != -1) {
            this.processBodyPart(emailMessage, part);
        } else if (part.isMimeType("text/plain") || part.isMimeType("text/html")) {
            emailMessage.setContent(part.getContent().toString());
        } else if (part.isMimeType("multipart/*")) {
            this.processMultipart(emailMessage, part);
        } else if (part.isMimeType("message/rfc822")) {
            this.getContent(emailMessage, (Part)part.getContent());
        } else {
            throw new MessageException("\u4e0d\u652f\u6301\u7684ContentType:" + contentType);
        }
    }

    private void processMultipart(EmailMessage emailMessage, Part part) throws IOException, MessagingException, MessageException {
        Multipart multipart = (Multipart)part.getContent();
        int counts = multipart.getCount();
        for (int i = 0; i < counts; ++i) {
            this.getContent(emailMessage, (Part)multipart.getBodyPart(i));
        }
    }

    private void processBodyPart(EmailMessage emailMessage, Part part) throws MessagingException, IOException {
        BodyPart bodyPart = (BodyPart)part;
        String disposition = bodyPart.getDisposition();
        if (disposition != null && (disposition.equals("attachment") || disposition.equals("inline"))) {
            EmailAccessory accessory = new EmailAccessory();
            accessory.setFileName(part.getFileName());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            part.writeTo((OutputStream)outputStream);
            accessory.setContent(outputStream.toByteArray());
            emailMessage.getAccessories().add(accessory);
        }
    }
}

