/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.message.email;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.tinygroup.message.MessageException;
import org.tinygroup.message.MessageSendService;
import org.tinygroup.message.email.EmailAccessory;
import org.tinygroup.message.email.EmailMessage;
import org.tinygroup.message.email.EmailMessageAccount;
import org.tinygroup.message.email.EmailMessageReceiver;
import org.tinygroup.message.email.EmailMessageSender;
import org.tinygroup.message.email.EmailMessageUtil;

public class EmailMessageSendService
implements MessageSendService<EmailMessageAccount, EmailMessageSender, EmailMessageReceiver, EmailMessage> {
    @Override
    public void sendMessage(EmailMessageAccount messageAccount, EmailMessageSender messageSender, Collection<EmailMessageReceiver> messageReceivers, EmailMessage emailMessage) throws MessageException {
        Session session = EmailMessageUtil.getSession(messageAccount);
        MimeMessage message = new MimeMessage(session);
        try {
            InternetAddress from = new InternetAddress(messageSender.getEmail(), messageSender.getDisplayName());
            message.setFrom((Address)from);
            for (EmailMessageReceiver receiver : messageReceivers) {
                InternetAddress receiverAddress = new InternetAddress(receiver.getEmail(), receiver.getDisplayName(), "UTF-8");
                message.addRecipient(receiver.getType(), (Address)receiverAddress);
            }
            message.setSubject(emailMessage.getSubject());
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            multipart.addBodyPart((BodyPart)part);
            part.setContent((Object)emailMessage.getContent(), "text/html;\n\tcharset=\"UTF-8\"");
            this.processAccessory(emailMessage, (Multipart)multipart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            throw new MessageException((Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageException(e);
        }
    }

    private void processAccessory(EmailMessage emailMessage, Multipart multipart) throws MessagingException {
        if (emailMessage.getAccessories() != null) {
            for (EmailAccessory accessory : emailMessage.getAccessories()) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                ByteArrayDataSource dataSource = new ByteArrayDataSource(accessory.getContent(), MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(accessory.getFileName()));
                mimeBodyPart.setFileName(accessory.getFileName());
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                multipart.addBodyPart((BodyPart)mimeBodyPart);
            }
        }
    }

    private String encode(String address) throws UnsupportedEncodingException {
        return MimeUtility.encodeText((String)address);
    }
}

