/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.message.email;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.MimeUtility;
import org.tinygroup.message.MessageException;
import org.tinygroup.message.email.EmailMessageAccount;

public final class EmailMessageUtil {
    private EmailMessageUtil() {
    }

    public static Session getSession(final EmailMessageAccount messageAccount) {
        Properties props = new Properties();
        props.put("mail.smtp.auth", (Object)messageAccount.isAuth());
        props.put("mail.smtp.starttls.enable", (Object)messageAccount.isStartTlsEnable());
        props.put("mail.smtp.host", messageAccount.getHost());
        if (messageAccount.getPort() != null) {
            props.put("mail.smtp.port", messageAccount.getPort());
        }
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(messageAccount.getUsername(), messageAccount.getPassword());
            }
        });
        return session;
    }

    public static byte[] decode(byte[] b) throws MessageException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            InputStream b64is = null;
            b64is = MimeUtility.decode((InputStream)bais, (String)"base64");
            byte[] tmp = new byte[b.length];
            int n = b64is.read(tmp);
            byte[] res = new byte[n];
            System.arraycopy(tmp, 0, res, 0, n);
            return res;
        }
        catch (Exception e) {
            throw new MessageException(e);
        }
    }
}

