/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.officeindexsource.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.fulltext.FullTextHelper;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.fulltext.exception.FullTextException;
import org.tinygroup.templateindex.impl.TemplateDocumentCreator;

public abstract class AbstractExcelIndexSource {
    protected static final int UNINIT = -1;
    private String fields;
    private int firstRow = -1;
    private int lastRow = -1;
    private int firstCol = -1;
    private int lastCol = -1;
    private TemplateDocumentCreator templateDocumentCreator;

    public String[] getFieldNames() {
        return this.fields == null ? new String[]{} : this.fields.split(",");
    }

    public String getFieldName(int index) {
        return this.getFieldNames()[index];
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public void setLastRow(int lastRow) {
        this.lastRow = lastRow;
    }

    public int getFirstCol() {
        return this.firstCol;
    }

    public void setFirstCol(int firstCol) {
        this.firstCol = firstCol;
    }

    public int getLastCol() {
        return this.lastCol;
    }

    public void setLastCol(int lastCol) {
        this.lastCol = lastCol;
    }

    public TemplateDocumentCreator getTemplateDocumentCreator() {
        return this.templateDocumentCreator;
    }

    public void setTemplateDocumentCreator(TemplateDocumentCreator templateDocumentCreator) {
        this.templateDocumentCreator = templateDocumentCreator;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Document> getDocument(String type, String path, InputStream input) {
        ArrayList<Document> docs = new ArrayList<Document>();
        Workbook wb = null;
        try {
            wb = this.createWorkbook(input);
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                Sheet sheet = wb.getSheetAt(i);
                this.dealSheet(sheet, type, docs);
            }
            if (wb == null) return docs;
        }
        catch (IOException e) {
            try {
                throw new FullTextException(String.format("\u8bfb\u53d6excel\u6587\u4ef6[%s]\u53d1\u751f\u5f02\u5e38:", path), (Throwable)e);
                catch (Exception e2) {
                    throw new FullTextException(String.format("\u52a0\u8f7dexcel\u6587\u4ef6[%s]\u4e3a\u7d22\u5f15\u6587\u6863\u65f6\u53d1\u751f\u5f02\u5e38:", path), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (wb == null) throw throwable;
                try {
                    wb.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new FullTextException(String.format("\u91ca\u653eexcel\u6587\u4ef6\u8d44\u6e90[%s]\u53d1\u751f\u5f02\u5e38:", path), (Throwable)e3);
                }
            }
        }
        try {
            wb.close();
            return docs;
        }
        catch (IOException e) {
            throw new FullTextException(String.format("\u91ca\u653eexcel\u6587\u4ef6\u8d44\u6e90[%s]\u53d1\u751f\u5f02\u5e38:", path), (Throwable)e);
        }
    }

    protected void dealSheet(Sheet sheet, String type, List<Document> docs) {
        int firstRow = this.getFirstRow() == -1 ? sheet.getFirstRowNum() : this.getFirstRow();
        int lastRow = this.getLastRow() == -1 ? sheet.getLastRowNum() : this.getLastRow();
        for (int i = firstRow; i <= lastRow; ++i) {
            Row row = sheet.getRow(i);
            int firstCol = this.getFirstCol() == -1 ? row.getFirstCellNum() : this.getFirstCol();
            int lastCol = this.getLastCol() == -1 ? row.getLastCellNum() : this.getLastCol();
            ContextImpl context = new ContextImpl();
            context.put(FullTextHelper.getStoreType(), (Object)type);
            for (int j = firstCol; j < lastCol; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) continue;
                String name = this.getFieldName(j - firstCol);
                this.updateContext(cell, name, (Context)context);
            }
            docs.add(this.getTemplateDocumentCreator().execute((Context)context));
        }
    }

    private void updateContext(Cell cell, String name, Context context) {
        switch (cell.getCellType()) {
            case 0: {
                context.put(name, (Object)cell.getNumericCellValue());
                break;
            }
            case 1: {
                context.put(name, (Object)cell.getStringCellValue());
                break;
            }
            case 2: {
                context.put(name, (Object)cell.getCellFormula());
                break;
            }
            case 3: {
                context.put(name, (Object)"");
                break;
            }
            case 4: {
                context.put(name, (Object)cell.getBooleanCellValue());
                break;
            }
            case 5: {
                context.put(name, (Object)cell.getErrorCellValue());
                break;
            }
            default: {
                context.put(name, (Object)cell.getStringCellValue());
            }
        }
    }

    protected abstract Workbook createWorkbook(InputStream var1) throws IOException;
}

