/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.order.processor;

import java.io.BufferedInputStream;
import java.util.List;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.order.processor.OrderGroup;
import org.tinygroup.order.processor.OrderGroups;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderProcessor<T> {
    public static final String ORDER_NAME = "orderProcessor";
    private static Logger logger = LoggerFactory.getLogger(OrderProcessor.class);
    private List<OrderGroups<T>> groupList = CollectionUtil.createArrayList();
    private List<String> fileNameCaches = CollectionUtil.createArrayList();

    public List<T> orderList(String name, List<T> list) {
        for (OrderGroups<T> groups : this.groupList) {
            OrderGroup<T> group = groups.get(name);
            if (group == null) continue;
            return group.initProcessorOrder(list);
        }
        throw new RuntimeException(String.format("can not found ordergroup with name of %s", name));
    }

    public void loadOrderFile(FileObject fileObject) {
        Assert.assertNotNull((Object)fileObject, (String)"fileObject must not null", (Object[])new Object[0]);
        String filePath = fileObject.getAbsolutePath();
        if (!this.fileNameCaches.contains(filePath)) {
            logger.logMessage(LogLevel.INFO, "\u8bfb\u53d6\u5bf9\u8c61\u52a0\u8f7d\u987a\u5e8f\u914d\u7f6e\u6587\u4ef6:<{}>\u5f00\u59cb", new Object[]{filePath});
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(fileObject.getInputStream());
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                inputStream.close();
                String content = new String(bytes, "UTF-8");
                logger.logMessage(LogLevel.INFO, "\u8bfb\u53d6\u5bf9\u8c61\u52a0\u8f7d\u987a\u5e8f\u914d\u7f6e\u6587\u4ef6\uff1a<{}>", new Object[]{filePath});
                XmlNode root = (XmlNode)new XmlStringParser().parse(content).getRoot();
                OrderGroups groups = new OrderGroups(root);
                groups.load();
                this.groupList.add(groups);
            }
            catch (Exception e) {
                logger.errorMessage("\u8bfb\u53d6\u5bf9\u8c61\u52a0\u8f7d\u987a\u5e8f\u914d\u7f6e\u6587\u4ef6\uff1a<{}>", (Throwable)e, new Object[]{filePath});
                throw new RuntimeException(e);
            }
            this.fileNameCaches.add(filePath);
        }
    }
}

