/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.order.processor;

import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.order.processor.OrderGroup;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderGroups<T> {
    private static final String DEFAULT_GROUP_NAME = "orderGroup";
    private Map<String, OrderGroup<T>> orderGroups = CollectionUtil.createHashMap();
    private XmlNode root;
    private static final String ORDER_GROUP = "order-group";

    public OrderGroups(XmlNode root) {
        this.root = root;
    }

    public OrderGroup<T> get(String name) {
        return this.orderGroups.get(name);
    }

    public void load() {
        NameFilter nameFilter = new NameFilter((Node)this.root);
        List nodes = nameFilter.findNodeList(ORDER_GROUP);
        for (XmlNode xmlNode : nodes) {
            OrderGroup group = new OrderGroup();
            String groupName = xmlNode.getAttribute("name");
            String defaultType = xmlNode.getAttribute("default-type");
            String defaultFeature = xmlNode.getAttribute("default-feature");
            if (defaultType == null || "".equals(defaultType)) {
                defaultType = "after";
            }
            if (defaultFeature == null || "".equals(defaultFeature)) {
                throw new RuntimeException("the order-group node must have default-feature properties");
            }
            group.setDefaultFeatureOrder(defaultType, defaultFeature);
            if (groupName == null) {
                groupName = DEFAULT_GROUP_NAME;
            }
            this.orderGroups.put(groupName, group);
            group.load(xmlNode);
        }
    }
}

