/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.order.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.order.order.AfterFeature;
import org.tinygroup.order.order.BeforeFeature;
import org.tinygroup.order.order.FeatureOrder;
import org.tinygroup.order.order.RequiresFeature;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.xmlparser.node.XmlNode;

public class OrderGroup<T> {
    private static final String ORDER_OBJECT = "order-object";
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderGroup.class);
    private static final String DEFAULT_FEATURE_NAME = "feature";
    private Map<Class<T>, String> groupMap = CollectionUtil.createHashMap();
    private Map<Class<T>, FeatureOrder[]> featureOrderMap = CollectionUtil.createHashMap();
    private FeatureOrder defaultFeatureOrder;

    protected void setDefaultFeatureOrder(String featureType, String feature) {
        this.defaultFeatureOrder = this.createFeatureOrder(featureType, feature);
    }

    public String getFeature(Class<T> type) {
        String feature = this.groupMap.get(type);
        if (feature == null) {
            feature = DEFAULT_FEATURE_NAME;
        }
        return feature;
    }

    public FeatureOrder[] getFeatureOrders(Class<T> type) {
        FeatureOrder[] featureOrders = this.featureOrderMap.get(type);
        if (featureOrders == null) {
            featureOrders = new FeatureOrder[]{this.defaultFeatureOrder};
        }
        return featureOrders;
    }

    public List<T> initProcessorOrder(List<T> processorList) {
        LOGGER.logMessage(LogLevel.INFO, "\u6587\u4ef6\u5904\u7406\u5668\u52a0\u8f7d\u987a\u5e8f\u5904\u7406\u5f00\u59cb");
        LinkedHashMap processorMap = CollectionUtil.createLinkedHashMap();
        HashSet processorSet = CollectionUtil.createHashSet();
        for (int i = 0; i < processorList.size(); ++i) {
            if (processorMap.containsKey(i)) continue;
            this.sort(i, processorList.get(i), processorList, processorMap, processorSet);
        }
        ArrayList newProcessorList = CollectionUtil.createArrayList(processorMap.values());
        HashSet usableFeatures = CollectionUtil.createHashSet();
        for (Object f : newProcessorList) {
            usableFeatures.add(this.getFeature(this.getType(f)));
            FeatureOrder[] featureOrders = this.getFeatureOrders(this.getType(f));
            if (featureOrders == null) continue;
            for (FeatureOrder requiresFeature : featureOrders) {
                if (!(requiresFeature instanceof RequiresFeature) || usableFeatures.contains(requiresFeature.getFeature())) continue;
                throw new IllegalArgumentException(String.format("Missing feature of %s, which is required by %s", requiresFeature.getFeature(), f));
            }
        }
        LOGGER.logMessage(LogLevel.INFO, "\u6587\u4ef6\u5904\u7406\u5668\u52a0\u8f7d\u987a\u5e8f\u5904\u7406\u7ed3\u675f");
        return newProcessorList;
    }

    private Class<T> getType(T f) {
        return f.getClass();
    }

    private void sort(int index, T processor, List<T> processorList, Map<Integer, T> processorMap, Set<Integer> processorSet) {
        if (!processorSet.contains(index)) {
            processorSet.add(index);
            for (Map.Entry<Integer, T> entry : this.getBefore(processor, processorList).entrySet()) {
                this.sort(entry.getKey(), entry.getValue(), processorList, processorMap, processorSet);
            }
            processorMap.put(index, processor);
            processorSet.remove(index);
        }
    }

    private Map<Integer, T> getBefore(T processor, List<T> processorList) {
        LinkedHashMap allBefore = CollectionUtil.createLinkedHashMap();
        for (int i = 0; i < processorList.size(); ++i) {
            T test = processorList.get(i);
            if (processor.equals(test) || this.compare(test, processor) >= 0) continue;
            allBefore.put(i, test);
        }
        return allBefore;
    }

    private int compare(T f1, T f2) {
        boolean f1BeforeF2 = this.compare(f1, BeforeFeature.class, f2);
        boolean f2AfterF1 = this.compare(f2, AfterFeature.class, f1);
        if (f1BeforeF2 || f2AfterF1) {
            return -1;
        }
        boolean f2BeforeF1 = this.compare(f2, BeforeFeature.class, f1);
        boolean f1AfterF2 = this.compare(f1, AfterFeature.class, f2);
        if (f2BeforeF1 || f1AfterF2) {
            return 1;
        }
        boolean f1BeforeAll = this.compareWithAll(f1, BeforeFeature.class);
        boolean f2AfterAll = this.compareWithAll(f2, AfterFeature.class);
        if (f1BeforeAll || f2AfterAll) {
            return -1;
        }
        boolean f2BeforeAll = this.compareWithAll(f2, BeforeFeature.class);
        boolean f1AfterAll = this.compareWithAll(f1, AfterFeature.class);
        if (f2BeforeAll || f1AfterAll) {
            return 1;
        }
        return 0;
    }

    private boolean compareWithAll(T f1, Class<? extends FeatureOrder> type) {
        FeatureOrder[] featureOrders = this.getFeatureOrders(this.getType(f1));
        if (ArrayUtil.isEmptyArray((Object)featureOrders)) {
            return false;
        }
        for (FeatureOrder featureOrder : featureOrders) {
            if (!type.isInstance(featureOrder) || !ObjectUtil.isEquals((Object)featureOrder.getFeature(), (Object)"*")) continue;
            return true;
        }
        return false;
    }

    private boolean compare(T f1, Class<? extends FeatureOrder> type, T f2) {
        FeatureOrder[] featureOrders = this.getFeatureOrders(this.getType(f1));
        String feature = this.getFeature(this.getType(f2));
        if (feature == null || "".equals(feature.trim()) || ArrayUtil.isEmptyArray((Object)featureOrders)) {
            return false;
        }
        for (FeatureOrder featureOrder : featureOrders) {
            if (!type.isInstance(featureOrder) || !ObjectUtil.isEquals((Object)featureOrder.getFeature(), (Object)feature)) continue;
            return true;
        }
        return false;
    }

    public void load(XmlNode xmlNode) {
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List nodes = nameFilter.findNodeList(ORDER_OBJECT);
        for (XmlNode node : nodes) {
            String name = node.getAttribute("name");
            String className = node.getAttribute("type");
            Class<?> type = null;
            try {
                type = Class.forName(className);
                this.groupMap.put(type, name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("\u627e\u4e0d\u5230\u540d\u79f0:<%s>\u5bf9\u5e94\u7684\u7c7b", className), e);
            }
            if (type == null) continue;
            this.loadFeature(node, type);
        }
    }

    private void loadFeature(XmlNode xmlNode, Class<T> type) {
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List nodes = nameFilter.findNodeList("feature-order");
        ArrayList orders = CollectionUtil.createArrayList();
        for (XmlNode node : nodes) {
            String featureType = node.getAttribute("type");
            String feature = node.getAttribute(DEFAULT_FEATURE_NAME);
            FeatureOrder featureOrder = this.createFeatureOrder(featureType, feature);
            orders.add(featureOrder);
        }
        this.featureOrderMap.put(type, orders.toArray(new FeatureOrder[0]));
    }

    private FeatureOrder createFeatureOrder(String featureType, String feature) {
        FeatureOrder order = null;
        if ("before".equals(featureType)) {
            order = new BeforeFeature(feature);
        } else if ("after".equals(featureType)) {
            order = new AfterFeature(feature);
        } else if ("require".equals(featureType)) {
            order = new RequiresFeature(feature);
        }
        return order;
    }
}

