/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sequence;

import java.util.concurrent.atomic.AtomicLong;

public class SequenceRange {
    private final long min;
    private final long max;
    private final AtomicLong value;
    private volatile boolean over = false;

    public SequenceRange(long min, long max) {
        this.min = min;
        this.max = max;
        this.value = new AtomicLong(min);
    }

    public long getAndIncrement() {
        long currentValue = this.value.getAndIncrement();
        if (currentValue > this.max) {
            this.over = true;
            return -1L;
        }
        return currentValue;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public boolean isOver() {
        return this.over;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        result = 31 * result + (this.over ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceRange other = (SequenceRange)obj;
        if (this.max != other.max) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        if (this.over != other.over) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public AtomicLong getValue() {
        return this.value;
    }

    public String toString() {
        return "SequenceRange [max=" + this.max + ", min=" + this.min + ", over=" + this.over + ", value=" + this.value.get() + "]";
    }
}

