/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sequence.impl;

import java.util.List;
import java.util.Random;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.sequence.DataSourceSelector;

public class DataSourceRandomSelector
implements DataSourceSelector {
    private static final Logger logger = LoggerFactory.getLogger((String)"tiny-sequence");
    private final int dataSourceNum;
    private final int[] weights;
    private final Random random = new Random();
    private final int DEFAULT_WEIGHT = 10;

    public DataSourceRandomSelector(int dataSourceNum) {
        this.dataSourceNum = dataSourceNum;
        this.weights = new int[dataSourceNum];
        for (int i = 0; i < dataSourceNum; ++i) {
            this.weights[i] = 10;
        }
    }

    public DataSourceRandomSelector(int[] weights) {
        this.weights = weights;
        this.dataSourceNum = weights.length;
    }

    @Override
    public int getRandomDataSourceIndex(List<Integer> excludeIndexes) {
        int[] tempWeights = (int[])this.weights.clone();
        for (int i = 0; i < this.dataSourceNum; ++i) {
            if (!excludeIndexes.contains(i)) continue;
            tempWeights[i] = 0;
        }
        int[] areaEnds = this.getAreaEnds(tempWeights);
        return this.select(areaEnds);
    }

    private int[] getAreaEnds(int[] weights) {
        if (weights == null) {
            return null;
        }
        int[] areaEnds = new int[weights.length];
        int sum = 0;
        for (int i = 0; i < weights.length; ++i) {
            areaEnds[i] = sum += weights[i];
        }
        return areaEnds;
    }

    private int select(int[] areaEnds) {
        int sum = areaEnds[areaEnds.length - 1];
        if (sum == 0) {
            logger.error("ERROR ## areaEnds: " + this.intArray2String(areaEnds));
            return -1;
        }
        int rand = this.random.nextInt(sum);
        for (int i = 0; i < areaEnds.length; ++i) {
            if (rand >= areaEnds[i]) continue;
            return i;
        }
        return -1;
    }

    private String intArray2String(int[] inta) {
        if (inta == null) {
            return "null";
        }
        if (inta.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(inta[0]);
        for (int i = 1; i < inta.length; ++i) {
            sb.append(", ").append(inta[i]);
        }
        sb.append("]");
        return sb.toString();
    }
}

