/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sequence.impl;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.tinygroup.sequence.Sequence;
import org.tinygroup.sequence.SequenceDao;
import org.tinygroup.sequence.SequenceRange;
import org.tinygroup.sequence.exception.SequenceException;

public class DefaultSequence
implements Sequence {
    private final Lock lock = new ReentrantLock();
    private SequenceDao sequenceDao;
    private String name;
    private volatile SequenceRange currentRange;

    @Override
    public long nextValue() throws SequenceException {
        long value;
        if (this.currentRange == null) {
            this.lock.lock();
            try {
                if (this.currentRange == null) {
                    this.currentRange = this.sequenceDao.nextRange(this.name);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if ((value = this.currentRange.getAndIncrement()) == -1L) {
            this.lock.lock();
            try {
                while (true) {
                    if (this.currentRange.isOver()) {
                        this.currentRange = this.sequenceDao.nextRange(this.name);
                    }
                    if ((value = this.currentRange.getAndIncrement()) == -1L) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (value < 0L) {
            throw new SequenceException("Sequence value overflow, value = {0}", value);
        }
        return value;
    }

    public SequenceDao getSequenceDao() {
        return this.sequenceDao;
    }

    public void setSequenceDao(SequenceDao sequenceDao) {
        this.sequenceDao = sequenceDao;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

