/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sequence.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.sequence.SequenceDao;
import org.tinygroup.sequence.SequenceRange;
import org.tinygroup.sequence.exception.SequenceException;

public class DefaultSequenceDao
implements SequenceDao {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tiny-sequence");
    private static final int MIN_STEP = 1;
    private static final int MAX_STEP = 100000;
    private static final int DEFAULT_STEP = 1000;
    private static final int DEFAULT_RETRY_TIMES = 150;
    private static final String DEFAULT_TABLE_NAME = "sequence";
    private static final String DEFAULT_NAME_COLUMN_NAME = "name";
    private static final String DEFAULT_VALUE_COLUMN_NAME = "value";
    private static final String DEFAULT_GMT_MODIFIED_COLUMN_NAME = "gmt_modified";
    private static final long THRESHOLD = 9223372036754775807L;
    private DataSource dataSource;
    private int retryTimes = 150;
    private int step = 1000;
    private String tableName = "sequence";
    private String nameColumnName = "name";
    private String valueColumnName = "value";
    private String gmtModifiedColumnName = "gmt_modified";
    private volatile String selectSql;
    private volatile String updateSql;
    private volatile String insertSql;

    @Override
    public SequenceRange nextRange(String name) throws SequenceException {
        if (name == null) {
            throw new IllegalArgumentException("\u5e8f\u5217\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        for (int i = 0; i < this.retryTimes + 1; ++i) {
            long newValue;
            long oldValue;
            try {
                int affectedRows;
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement(this.getSelectSql());
                stmt.setString(1, name);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    oldValue = rs.getLong(1);
                    if (oldValue < 0L) {
                        StringBuilder message = new StringBuilder();
                        message.append("Sequence value cannot be less than zero, value = ").append(oldValue);
                        message.append(", please check table ").append(this.getTableName());
                        throw new SequenceException(message.toString(), new Object[0]);
                    }
                    if (oldValue > 9223372036754775807L) {
                        StringBuilder message = new StringBuilder();
                        message.append("Sequence value overflow, value = ").append(oldValue);
                        message.append(", please check table ").append(this.getTableName());
                        throw new SequenceException(message.toString(), new Object[0]);
                    }
                    newValue = oldValue + (long)this.getStep();
                    stmt = conn.prepareStatement(this.getUpdateSql());
                    stmt.setLong(1, newValue);
                    stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    stmt.setString(3, name);
                    stmt.setLong(4, oldValue);
                    affectedRows = stmt.executeUpdate();
                    if (affectedRows == 0) continue;
                } else {
                    stmt = conn.prepareStatement(this.getInsertSql());
                    stmt.setLong(1, this.getStep());
                    stmt.setString(2, name);
                    stmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    affectedRows = stmt.executeUpdate();
                    if (affectedRows == 0) continue;
                    oldValue = 0L;
                    newValue = oldValue + (long)this.getStep();
                }
            }
            catch (SQLException e) {
                throw new SequenceException(e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
                }
            }
            return new SequenceRange(oldValue + 1L, newValue);
        }
        throw new SequenceException("Retried too many times, retryTimes = " + this.retryTimes, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelectSql() {
        if (this.selectSql == null) {
            DefaultSequenceDao defaultSequenceDao = this;
            synchronized (defaultSequenceDao) {
                if (this.selectSql == null) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("select ").append(this.getValueColumnName());
                    buffer.append(" from ").append(this.getTableName());
                    buffer.append(" where ").append(this.getNameColumnName()).append(" = ?");
                    this.selectSql = buffer.toString();
                }
            }
        }
        return this.selectSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUpdateSql() {
        if (this.updateSql == null) {
            DefaultSequenceDao defaultSequenceDao = this;
            synchronized (defaultSequenceDao) {
                if (this.updateSql == null) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("update ").append(this.getTableName());
                    buffer.append(" set ").append(this.getValueColumnName()).append(" = ?, ");
                    buffer.append(this.getGmtModifiedColumnName()).append(" = ? where ");
                    buffer.append(this.getNameColumnName()).append(" = ? and ");
                    buffer.append(this.getValueColumnName()).append(" = ?");
                    this.updateSql = buffer.toString();
                }
            }
        }
        return this.updateSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInsertSql() {
        if (this.insertSql == null) {
            DefaultSequenceDao defaultSequenceDao = this;
            synchronized (defaultSequenceDao) {
                if (this.insertSql == null) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("insert into ").append(this.getTableName());
                    buffer.append(" (").append(this.getValueColumnName()).append(",").append(this.getNameColumnName()).append(",").append(this.getGmtModifiedColumnName()).append(")").append(" values (?,?,?)");
                    this.insertSql = buffer.toString();
                }
            }
        }
        return this.insertSql;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        if (retryTimes < 0) {
            throw new IllegalArgumentException("Property retryTimes cannot be less than zero, retryTimes = " + retryTimes);
        }
        this.retryTimes = retryTimes;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        if (step < 1 || step > 100000) {
            StringBuilder message = new StringBuilder();
            message.append("Property step out of range [").append(1);
            message.append(",").append(100000).append("], step = ").append(step);
            throw new IllegalArgumentException(message.toString());
        }
        this.step = step;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getNameColumnName() {
        return this.nameColumnName;
    }

    public void setNameColumnName(String nameColumnName) {
        this.nameColumnName = nameColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    public String getGmtModifiedColumnName() {
        return this.gmtModifiedColumnName;
    }

    public void setGmtModifiedColumnName(String gmtModifiedColumnName) {
        this.gmtModifiedColumnName = gmtModifiedColumnName;
    }
}

