/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sequence.impl;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.sequence.Sequence;
import org.tinygroup.sequence.SequenceRange;
import org.tinygroup.sequence.exception.SequenceException;
import org.tinygroup.sequence.impl.MultipleSequenceDao;

public class MultipleSequence
implements Sequence {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tiny-sequence");
    private static final int DEFAULT_STEP = 1000;
    private static final long DEFAULT_MIN_VALUE = 0L;
    private static final long DEFAULT_MAX_VALUE = Long.MAX_VALUE;
    private final Lock lock = new ReentrantLock();
    private int innerStep = 1000;
    private long minValue = 0L;
    private long maxValue = Long.MAX_VALUE;
    private String sequenceName;
    private volatile SequenceRange currentRange;
    private MultipleSequenceDao sequenceDao;
    private volatile boolean isInitialize = false;

    public MultipleSequence() {
    }

    public MultipleSequence(MultipleSequenceDao sequenceDao, String sequenceName, long minValue, long maxValue, int innerStep) {
        this.sequenceDao = sequenceDao;
        this.sequenceName = sequenceName;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.innerStep = innerStep;
    }

    public void init() throws SequenceException {
        if (this.isInitialize) {
            throw new SequenceException("ERROR ## the MultipleSequence has inited", new Object[0]);
        }
        if (this.sequenceDao == null) {
            throw new IllegalArgumentException("ERROR ## the sequenceDao is null");
        }
        if (this.sequenceName == null || this.sequenceName.trim().length() == 0) {
            throw new IllegalArgumentException("ERROR ## the sequenceName is null");
        }
        if (this.minValue < 0L) {
            throw new IllegalArgumentException("ERROR ## the minValue is less than zero");
        }
        if (this.maxValue < 0L) {
            throw new IllegalArgumentException("ERROR ## the maxValue is less than zero");
        }
        this.sequenceDao.initSequenceRecord(this.sequenceName, this.minValue, this.maxValue, this.innerStep);
        LOGGER.logMessage(LogLevel.WARN, "WARN ## init the multipleSequence success,the sequenceName ={0}", new Object[]{this.sequenceName});
        this.isInitialize = true;
    }

    @Override
    public long nextValue() throws SequenceException {
        long value;
        if (!this.isInitialize) {
            throw new SequenceException("ERROR ## the MultipleSequence is not init", new Object[0]);
        }
        if (this.currentRange == null) {
            this.lock.lock();
            try {
                if (this.currentRange == null) {
                    this.currentRange = this.sequenceDao.nextRange(this.sequenceName, this.minValue, this.maxValue, this.innerStep);
                    LOGGER.logMessage(LogLevel.WARN, "WARN ## get the sequence range, from  {0} to  {1},the sequenceName = {2}", new Object[]{this.currentRange.getMin(), this.currentRange.getMax(), this.sequenceName});
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if ((value = this.currentRange.getAndIncrement()) == -1L) {
            this.lock.lock();
            try {
                while (true) {
                    if (this.currentRange.isOver()) {
                        this.currentRange = this.sequenceDao.nextRange(this.sequenceName, this.minValue, this.maxValue, this.innerStep);
                        LOGGER.logMessage(LogLevel.WARN, "WARN ## after over,get the sequence range, from {0} to {1}, the sequenceName = {2}", new Object[]{this.currentRange.getMin(), this.currentRange.getMax(), this.sequenceName});
                    }
                    if ((value = this.currentRange.getAndIncrement()) == -1L) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (value < 0L) {
            throw new SequenceException("Sequence value overflow, value = " + value, new Object[0]);
        }
        return value;
    }

    public MultipleSequenceDao getSequenceDao() {
        return this.sequenceDao;
    }

    public void setSequenceDao(MultipleSequenceDao sequenceDao) {
        this.sequenceDao = sequenceDao;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String name) {
        this.sequenceName = name;
    }

    public int getInnerStep() {
        return this.innerStep;
    }

    public void setInnerStep(int innerStep) {
        this.innerStep = innerStep;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }
}

