/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sequence.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.sequence.DataSourceSelector;
import org.tinygroup.sequence.SequenceRange;
import org.tinygroup.sequence.exception.SequenceException;
import org.tinygroup.sequence.impl.DataSourceRandomSelector;
import org.tinygroup.sequence.impl.SequenceDataSourceHolder;

public class MultipleSequenceDao {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tiny-sequence");
    private static final String DEFAULT_TABLE_NAME = "sequence";
    private static final String DEFAULT_NAME_COLUMN_NAME = "name";
    private static final String DEFAULT_VALUE_COLUMN_NAME = "value";
    private static final String DEFAULT_MIN_VALUE_COLUMN_NAME = "min_value";
    private static final String DEFAULT_MAX_VALUE_COLUMN_NAME = "max_value";
    private static final String DEFAULT_INNER_STEP_COLUMN_NAME = "step";
    private static final String DEFAULT_GMT_CREATE_COLUMN_NAME = "gmt_create";
    private static final String DEFAULT_GMT_MODIFIED_COLUMN_NAME = "gmt_modified";
    private final int DEFAULT_DATA_SOURCE_NUMBER = 2;
    private int dataSourceNum = 2;
    private List<SequenceDataSourceHolder> dataSourceList = new ArrayList<SequenceDataSourceHolder>();
    private int retryTimes = 150;
    private DataSourceSelector dataSourceSelector;
    private String tableName = "sequence";
    private String nameColumnName = "name";
    private String valueColumnName = "value";
    private String minValueColumnName = "min_value";
    private String maxValueColumnName = "max_value";
    private String innerStepColumnName = "step";
    private String gmtCreateColumnName = "gmt_create";
    private String gmtModifiedColumnName = "gmt_modified";
    private Boolean adjust = true;
    private String selectSql;
    private String updateSql;
    private String insertSql;
    private String selectAllRecordSql;
    private String selectSeqRecordSql;
    private volatile boolean isInitialize = false;

    public void init() {
        if (this.isInitialize) {
            throw new SequenceException("ERROR ## the MultipleSequenceDao has inited", new Object[0]);
        }
        this.dataSourceNum = this.dataSourceList.size();
        if (this.dataSourceNum < 2) {
            throw new IllegalArgumentException("\u4e3a\u4fdd\u8bc1\u9ad8\u53ef\u7528\uff0c\u6570\u636e\u6e90\u7684\u4e2a\u6570\u5efa\u8bae\u8bbe\u7f6e\u591a\u4e8e\u4e24\u4e2a,size=" + this.dataSourceNum);
        }
        if (this.dataSourceSelector == null) {
            this.dataSourceSelector = new DataSourceRandomSelector(this.dataSourceNum);
        }
        LOGGER.logMessage(LogLevel.WARN, "\u521d\u59cb\u5316\u7ed3\u675f,\u5176\u4e2ddataSourceNum={0}", new Object[]{this.dataSourceNum});
        for (SequenceDataSourceHolder dsHolder : this.dataSourceList) {
            dsHolder.setParameters(this.getTableName(), this.getSelectSql(), this.getUpdateSql(), this.getInsertSql(), this.adjust);
        }
        this.isInitialize = true;
    }

    public void initSequenceRecord(String sequenceName, long minValue, long maxValue, int innerStep) throws SequenceException {
        if (!this.isInitialize) {
            throw new SequenceException("ERROR ## please init the MultipleSequenceDao first", new Object[0]);
        }
        for (int index = 0; index < this.dataSourceNum; ++index) {
            SequenceDataSourceHolder dsHolder = this.dataSourceList.get(index);
            dsHolder.initSequenceRecord(index, sequenceName, innerStep, innerStep * this.dataSourceNum, minValue, maxValue, this.getValueColumnName());
        }
    }

    public Map<String, Map<String, Object>> getAllSequenceNameRecord() throws SQLException {
        Map<String, Map<String, Object>> sequenceRecordMap = new HashMap<String, Map<String, Object>>(0);
        for (int i = 0; i < this.dataSourceList.size(); ++i) {
            try {
                SequenceDataSourceHolder dsHolder = this.dataSourceList.get(i);
                sequenceRecordMap = dsHolder.getAllSequenceRecordName(this.getSelectAllRecord(), this.getNameColumnName(), this.getMinValueColumnName(), this.getMaxValueColumnName(), this.getInnerStepColumnName());
                break;
            }
            catch (Exception e) {
                LOGGER.logMessage(LogLevel.WARN, "The {0}th datasource failed,", (Throwable)e, new Object[]{i});
                continue;
            }
        }
        return sequenceRecordMap;
    }

    public Map<String, Map<String, Object>> getSequenceRecordByName(String sequenceName) throws SQLException, SequenceException {
        if (!this.isInitialize) {
            throw new SequenceException("ERROR ## please init the MultipleSequenceDao first", new Object[0]);
        }
        HashMap<String, Map<String, Object>> sequenceRecordMap = new HashMap(0);
        SequenceDataSourceHolder dsHolder = this.dataSourceList.get(0);
        sequenceRecordMap = dsHolder.getSequenceRecordByName(this.getSequenceRecordSql(), this.getMinValueColumnName(), this.getMaxValueColumnName(), this.getInnerStepColumnName(), sequenceName);
        return sequenceRecordMap;
    }

    public SequenceRange nextRange(String sequenceName, long minValue, long maxValue, int innerStep) throws SequenceException {
        if (!this.isInitialize) {
            throw new SequenceException("ERROR ## please init the MultipleSequenceDao first", new Object[0]);
        }
        if (sequenceName == null || sequenceName.trim().length() == 0) {
            throw new IllegalArgumentException("ERROR ## \u5e8f\u5217\u8868\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        for (int i = 0; i < this.retryTimes; ++i) {
            int index;
            ArrayList<Integer> excludeIndexes = new ArrayList<Integer>(0);
            for (int j = 0; j < this.dataSourceNum && (index = this.dataSourceSelector.getRandomDataSourceIndex(excludeIndexes)) != -1; ++j) {
                SequenceDataSourceHolder dsHolder = this.dataSourceList.get(index);
                SequenceRange sequenceRange = null;
                sequenceRange = dsHolder.tryOnSelectedDataSource(index, sequenceName, minValue, maxValue, innerStep, innerStep * this.dataSourceNum, excludeIndexes);
                if (sequenceRange != null) {
                    return sequenceRange;
                }
                LOGGER.logMessage(LogLevel.WARN, "WARN ## \u91cd\u8bd5\u53bb\u53d6 sequenceRange\uff0c\u7b2c{0}\u6b21\u5c1d\u8bd5!", new Object[]{i + 1});
            }
        }
        throw new SequenceException("MultipleSequenceDao\u6ca1\u6709\u53ef\u7528\u7684\u6570\u636e\u6e90\u4e86,\u6570\u636e\u6e90\u4e2a\u6570dataSourceNum=" + this.dataSourceNum + ",\u91cd\u8bd5\u6b21\u6570retryTimes=" + this.retryTimes, new Object[0]);
    }

    private String getSelectSql() {
        if (this.selectSql == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("select ").append(this.getValueColumnName());
            buffer.append(" from ").append(this.getTableName());
            buffer.append(" where ").append(this.getNameColumnName()).append(" = ?");
            this.selectSql = buffer.toString();
        }
        return this.selectSql;
    }

    public String getSequenceRecordSql() {
        if (this.selectSeqRecordSql == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("select ").append(this.getNameColumnName()).append(",");
            buffer.append(this.getValueColumnName()).append(",");
            buffer.append(this.getMinValueColumnName()).append(",");
            buffer.append(this.getMaxValueColumnName()).append(",");
            buffer.append(this.getInnerStepColumnName());
            buffer.append(" from ").append(this.getTableName());
            buffer.append(" where ").append(this.getNameColumnName()).append("= ?");
            this.selectSeqRecordSql = buffer.toString();
        }
        return this.selectSeqRecordSql;
    }

    private String getUpdateSql() {
        if (this.updateSql == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("update ").append(this.getTableName());
            buffer.append(" set ").append(this.getValueColumnName()).append(" = ?, ");
            buffer.append(this.getGmtModifiedColumnName()).append(" = ? where ");
            buffer.append(this.getNameColumnName()).append(" = ? and ");
            buffer.append(this.getValueColumnName()).append("=?");
            this.updateSql = buffer.toString();
        }
        return this.updateSql;
    }

    private String getInsertSql() {
        if (this.insertSql == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("insert into ").append(this.getTableName()).append("(");
            buffer.append(this.getNameColumnName()).append(",");
            buffer.append(this.getValueColumnName()).append(",");
            buffer.append(this.getMinValueColumnName()).append(",");
            buffer.append(this.getMaxValueColumnName()).append(",");
            buffer.append(this.getInnerStepColumnName()).append(",");
            buffer.append(this.getGmtCreateColumnName()).append(",");
            buffer.append(this.getGmtModifiedColumnName()).append(") values(?,?,?,?,?,?,?);");
            this.insertSql = buffer.toString();
        }
        return this.insertSql;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public List<SequenceDataSourceHolder> getDataSourceList() {
        return this.dataSourceList;
    }

    public void setDataSourceList(List<DataSource> dataSourceList) {
        if (dataSourceList.size() == 0 || dataSourceList == null) {
            throw new IllegalArgumentException("the dataSourceList is empty!");
        }
        for (DataSource ds : dataSourceList) {
            SequenceDataSourceHolder dsHolder = new SequenceDataSourceHolder(ds);
            this.dataSourceList.add(dsHolder);
        }
    }

    public String getSelectAllRecord() {
        if (this.selectAllRecordSql == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("select ").append(this.getNameColumnName()).append(",");
            buffer.append(this.getValueColumnName()).append(",");
            buffer.append(this.getMinValueColumnName()).append(",");
            buffer.append(this.getMaxValueColumnName()).append(",");
            buffer.append(this.getInnerStepColumnName());
            buffer.append(" from ").append(this.getTableName());
            this.selectAllRecordSql = buffer.toString();
        }
        return this.selectAllRecordSql;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getNameColumnName() {
        return this.nameColumnName;
    }

    public void setNameColumnName(String nameColumnName) {
        this.nameColumnName = nameColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    public String getGmtModifiedColumnName() {
        return this.gmtModifiedColumnName;
    }

    public void setGmtModifiedColumnName(String gmtModifiedColumnName) {
        this.gmtModifiedColumnName = gmtModifiedColumnName;
    }

    public Boolean getAdjust() {
        return this.adjust;
    }

    public void setAdjust(Boolean adjust) {
        this.adjust = adjust;
    }

    public String getGmtCreateColumnName() {
        return this.gmtCreateColumnName;
    }

    public void setGmtCreateColumnName(String gmtCreateColumnName) {
        this.gmtCreateColumnName = gmtCreateColumnName;
    }

    public String getMinValueColumnName() {
        return this.minValueColumnName;
    }

    public void setMinValueColumnName(String minValueColumnName) {
        this.minValueColumnName = minValueColumnName;
    }

    public String getMaxValueColumnName() {
        return this.maxValueColumnName;
    }

    public void setMaxValueColumnName(String maxValueColumnName) {
        this.maxValueColumnName = maxValueColumnName;
    }

    public String getInnerStepColumnName() {
        return this.innerStepColumnName;
    }

    public void setInnerStepColumnName(String innerStepColumnName) {
        this.innerStepColumnName = innerStepColumnName;
    }

    public DataSourceSelector getDataSourceSelector() {
        return this.dataSourceSelector;
    }

    public void setDataSourceSelector(DataSourceSelector dataSourceSelector) {
        this.dataSourceSelector = dataSourceSelector;
    }
}

