/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sequence.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.sequence.impl.MultipleSequence;
import org.tinygroup.sequence.impl.MultipleSequenceDao;

public class MultipleSequenceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tiny-sequence");
    private final Lock lock = new ReentrantLock();
    private Map<String, MultipleSequence> multipleSequenceMap = new ConcurrentHashMap<String, MultipleSequence>();
    private MultipleSequenceDao multipleSequenceDao;

    public void init() {
        if (this.multipleSequenceDao == null) {
            throw new IllegalArgumentException("The sequenceDao is null!");
        }
        this.multipleSequenceDao.init();
        this.initMultipleSequenceMap();
    }

    private void initMultipleSequenceMap() {
        Map<String, Map<String, Object>> sequenceRecords = null;
        try {
            sequenceRecords = this.multipleSequenceDao.getAllSequenceNameRecord();
            if (sequenceRecords == null) {
                throw new IllegalArgumentException("ERROR ## The sequenceRecord is null!");
            }
            for (Map.Entry<String, Map<String, Object>> sequenceRecord : sequenceRecords.entrySet()) {
                String seqName = sequenceRecord.getKey().trim();
                Map<String, Object> sequenceRecordValue = sequenceRecord.getValue();
                long min = (Long)sequenceRecordValue.get(this.multipleSequenceDao.getMinValueColumnName());
                long max = (Long)sequenceRecordValue.get(this.multipleSequenceDao.getMaxValueColumnName());
                int step = (Integer)sequenceRecordValue.get(this.multipleSequenceDao.getInnerStepColumnName());
                MultipleSequence multipleSequence = new MultipleSequence(this.multipleSequenceDao, seqName, min, max, step);
                try {
                    multipleSequence.init();
                    this.multipleSequenceMap.put(seqName, multipleSequence);
                }
                catch (Exception e) {
                    LOGGER.errorMessage("ERROR ## init the sequenceName = {0} has an error:", (Throwable)e, new Object[]{seqName});
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("ERROR ## init the multiple-Sequence-Map failed!", (Throwable)e);
        }
    }

    private void initOneMultipleSequenceRecord(String sequenceName) throws Exception {
        Map<String, Map<String, Object>> sequenceRecords = null;
        try {
            sequenceRecords = this.multipleSequenceDao.getSequenceRecordByName(sequenceName);
            if (sequenceRecords == null) {
                throw new IllegalArgumentException("The sequenceRecord is null,sequenceName=" + sequenceName);
            }
            for (Map.Entry<String, Map<String, Object>> sequenceRecord : sequenceRecords.entrySet()) {
                String seqName = sequenceRecord.getKey().trim();
                Map<String, Object> sequeceRecordvalue = sequenceRecord.getValue();
                long min = (Long)sequeceRecordvalue.get(this.multipleSequenceDao.getMinValueColumnName());
                long max = (Long)sequeceRecordvalue.get(this.multipleSequenceDao.getMaxValueColumnName());
                int step = (Integer)sequeceRecordvalue.get(this.multipleSequenceDao.getInnerStepColumnName());
                MultipleSequence multipleSequence = new MultipleSequence(this.multipleSequenceDao, seqName, min, max, step);
                multipleSequence.init();
                this.multipleSequenceMap.put(seqName, multipleSequence);
            }
        }
        catch (Exception e) {
            LOGGER.errorMessage("init the multipleSequenceMap failed!", (Throwable)e, new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextValue(String sequenceName) throws Exception {
        if (StringUtil.isBlank((String)sequenceName)) {
            throw new IllegalArgumentException("The sequence name can not be null!");
        }
        MultipleSequence multipleSequence = this.multipleSequenceMap.get(sequenceName);
        if (multipleSequence != null) {
            return multipleSequence.nextValue();
        }
        try {
            this.lock.lock();
            if (this.multipleSequenceMap.get(sequenceName) == null) {
                this.initOneMultipleSequenceRecord(sequenceName);
            }
            long l = this.multipleSequenceMap.get(sequenceName).nextValue();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public MultipleSequenceDao getMultipleSequenceDao() {
        return this.multipleSequenceDao;
    }

    public void setMultipleSequenceDao(MultipleSequenceDao sequenceDao) {
        this.multipleSequenceDao = sequenceDao;
    }
}

