/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.sequence.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.sequence.SequenceRange;
import org.tinygroup.sequence.exception.SequenceException;

public class SequenceDataSourceHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tiny-sequence");
    private final DataSource ds;
    private final ReentrantLock lock = new ReentrantLock();
    private final int retryBadDbInterval = 30000;
    private final int timeInterval = 300000;
    private final int allowExceptionTimes = 20;
    private volatile boolean isAvailable = true;
    private volatile long lastRetryTime = 0L;
    private volatile int exceptionTimes = 0;
    private volatile long firstExceptionTime = 0L;
    private String tableName;
    private boolean adjust;
    private String selectSql;
    private String updateSql;
    private String insertSql;

    public SequenceDataSourceHolder(DataSource ds) {
        this.ds = ds;
    }

    public void setParameters(String tableName, String selectSql, String updateSql, String insertSql, boolean adjust) {
        this.tableName = tableName;
        this.selectSql = selectSql;
        this.updateSql = updateSql;
        this.insertSql = insertSql;
        this.adjust = adjust;
    }

    public DataSource getDs() {
        return this.ds;
    }

    public SequenceRange tryOnSelectedDataSource(int index, String sequenceName, long minValue, long maxValue, int innerStep, int outStep, List<Integer> excludeIndexes) throws SequenceException {
        if (this.isAvailable) {
            return this.tryOnAvailableDataSource(index, sequenceName, minValue, maxValue, innerStep, outStep, excludeIndexes);
        }
        return this.tryOnFailedDataSource(index, sequenceName, minValue, maxValue, innerStep, outStep, excludeIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceRange tryOnAvailableDataSource(int index, String sequenceName, long minValue, long maxValue, int innerStep, int outStep, List<Integer> excludeIndexes) throws SequenceException {
        long adjustValue = -1L;
        long oldValue = -1L;
        long newValue = -1L;
        long beginValue = -1L;
        long endValue = -1L;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            stmt = con.prepareStatement(this.selectSql);
            stmt.setString(1, sequenceName);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new SequenceException("No sequence record in the table:" + this.tableName + ",please initialize it!", new Object[0]);
            }
            oldValue = rs.getLong(1);
            if (oldValue < 0L || oldValue > maxValue || oldValue < minValue) {
                StringBuilder message = new StringBuilder();
                message.append("Sequence value set error, currentValue = " + oldValue + ",minValue=" + minValue + ",maxValue=" + maxValue);
                message.append(", please check table: ").append(this.tableName);
                throw new SequenceException(message.toString(), new Object[0]);
            }
            adjustValue = this.getAjustValue(index, oldValue, minValue, maxValue, innerStep, outStep, sequenceName, false);
            beginValue = adjustValue;
            if (beginValue >= maxValue) {
                beginValue = this.getAjustValue(index, minValue, minValue, maxValue, innerStep, outStep, sequenceName, true);
            }
            endValue = (endValue = beginValue + (long)innerStep) > maxValue ? maxValue : --endValue;
            if (beginValue > endValue) {
                throw new SequenceException("SEQUENCE-VALUE-ERROR:beginValue=" + beginValue + " is larg than endValue=" + endValue, new Object[0]);
            }
            newValue = beginValue + (long)outStep;
            if (newValue > maxValue) {
                newValue = this.getAjustValue(index, minValue, minValue, maxValue, innerStep, outStep, sequenceName, true);
            }
        }
        catch (SQLException e) {
            LOGGER.logMessage(LogLevel.WARN, "WARN ## \u53d6sequence\u8303\u56f4\u8fc7\u7a0b\u4e2d\u51fa\u9519,db-index={0},oldValue={1},newValue={2}", (Throwable)e, new Object[]{index, oldValue, newValue});
            this.calculateExceptionTimes(index);
            excludeIndexes.add(index);
            SequenceRange sequenceRange = null;
            return sequenceRange;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
            }
        }
        try {
            stmt = con.prepareStatement(this.updateSql);
            stmt.setLong(1, newValue);
            long gmt_modified = System.currentTimeMillis();
            stmt.setTimestamp(2, new Timestamp(gmt_modified));
            stmt.setString(3, sequenceName);
            stmt.setLong(4, oldValue);
            int affectedRows = stmt.executeUpdate();
            if (affectedRows == 0) {
                LOGGER.logMessage(LogLevel.WARN, "WARN ## \u66f4\u65b0sequence\u8bb0\u5f55\u5931\u8d25\uff0coldValue={0},newValue={1}", new Object[]{oldValue, newValue});
                SequenceRange sequenceRange = null;
                return sequenceRange;
            }
            LOGGER.logMessage(LogLevel.WARN, "WARN ## Update the sequence of {0} th dataSource to {1} from {2}", new Object[]{index, newValue, oldValue});
            SequenceRange sequenceRange = new SequenceRange(beginValue, endValue);
            return sequenceRange;
        }
        catch (SQLException e) {
            LOGGER.logMessage(LogLevel.WARN, "WARN ## \u66f4\u65b0sequence\u8fc7\u7a0b\u4e2d\u51fa\u9519,index={0},oldValue={1},newValue={2}", (Throwable)e, new Object[]{index, oldValue, newValue});
            this.calculateExceptionTimes(index);
            excludeIndexes.add(index);
            SequenceRange sequenceRange = null;
            return sequenceRange;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
            }
        }
    }

    private long getAjustValue(int index, long oldValue, long minValue, long maxValue, int innerStep, int outStep, String sequenceName, boolean isLoop) throws SequenceException {
        if (minValue > maxValue || minValue + (long)innerStep > maxValue) {
            throw new SequenceException("ERROR ## SET-VALUE-ERROR:thread-name=" + Thread.currentThread().getName() + "minValue=" + minValue + ",maxValue=" + maxValue + ",innerStep=" + innerStep + ",outStep" + outStep, new Object[0]);
        }
        long adjustValue = oldValue;
        if (!this.check(index, oldValue, innerStep, outStep)) {
            if (this.adjust) {
                long value1 = index * innerStep;
                long value2 = oldValue - oldValue % (long)outStep + (long)(index * innerStep);
                long value3 = oldValue - oldValue % (long)outStep + (long)outStep + (long)(index * innerStep);
                if (value1 >= oldValue) {
                    adjustValue = value1;
                } else if (value2 >= oldValue) {
                    adjustValue = value2;
                } else if (value3 >= oldValue) {
                    adjustValue = value3;
                }
                LOGGER.logMessage(LogLevel.WARN, "WARN ## SEQUENCE-AJUST-SUCCESS:thread-name={0},sequenceName={1},dbIndex={2},oldValue={3},adjustValue={4},isLoop={5}", new Object[]{Thread.currentThread().getName(), sequenceName, index, oldValue, adjustValue, isLoop});
                if (adjustValue < minValue || adjustValue > maxValue) {
                    throw new SequenceException("WARN ## AJUST-VALUE-FAILURED:thread-name={0},seqName={1},dbIndex={2},ajustValue={3},minValue={4},maxValue={5}", Thread.currentThread().getName(), sequenceName, index, adjustValue, minValue, maxValue);
                }
            } else {
                throw new SequenceException("SEQUENCE-VALUE-ERROR:thread-name={0},seqName={1},db-index={2},oldValue={3},innerStep={4},outStep={5},seq\u503c\u9519\u8bef\uff0c\u8986\u76d6\u5230\u5176\u4ed6\u8303\u56f4\u6bb5\u4e86\uff01\u8bf7\u4fee\u6539\u6570\u636e\u5e93\uff0c\u6216\u8005\u5f00\u542fadjust\u5f00\u5173\uff01", Thread.currentThread().getName(), sequenceName, index, oldValue, innerStep, outStep);
            }
        }
        return adjustValue;
    }

    public Map<String, Map<String, Object>> getAllSequenceRecordName(String selectSql, String nameColumn, String minValueColumnName, String maxValueColumnName, String innerStepColumnName) throws SQLException {
        HashMap<String, Map<String, Object>> records = new HashMap<String, Map<String, Object>>(0);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            stmt = con.prepareStatement(selectSql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(nameColumn);
                long min = rs.getLong(minValueColumnName);
                long max = rs.getLong(maxValueColumnName);
                int step = rs.getInt(innerStepColumnName);
                if (records.get(name) != null) continue;
                HashMap<String, Number> keyAndValue = new HashMap<String, Number>(0);
                keyAndValue.put(minValueColumnName, min);
                keyAndValue.put(maxValueColumnName, max);
                keyAndValue.put(innerStepColumnName, step);
                records.put(name, keyAndValue);
            }
        }
        catch (SQLException e) {
            LOGGER.errorMessage("get all the sequence record failed!", (Throwable)e, new Object[0]);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
            }
        }
        return records;
    }

    public Map<String, Map<String, Object>> getSequenceRecordByName(String selectSql, String minValueColumnName, String maxValueColumnName, String innerStepColumnName, String sequenceName) throws SQLException, SequenceException {
        HashMap<String, Map<String, Object>> records = new HashMap<String, Map<String, Object>>(0);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            stmt = con.prepareStatement(selectSql);
            stmt.setString(1, sequenceName);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new SequenceException("can not find the record, name={0}", sequenceName);
            }
            long min = rs.getLong(minValueColumnName);
            long max = rs.getLong(maxValueColumnName);
            int step = rs.getInt(innerStepColumnName);
            if (records.get(sequenceName) == null) {
                HashMap<String, Number> keyAndValue = new HashMap<String, Number>(0);
                keyAndValue.put(minValueColumnName, min);
                keyAndValue.put(maxValueColumnName, max);
                keyAndValue.put(innerStepColumnName, step);
                records.put(sequenceName, keyAndValue);
            }
        }
        catch (SQLException e) {
            throw new SequenceException("ERROR ## get the sequence record failed,name={0}", e, sequenceName);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
            }
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryToConnectDataBase(int dbIndex) {
        Long beginTime = System.currentTimeMillis();
        boolean isSussessful = true;
        String sql = "select 'x' ";
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.ds.getConnection();
            stmt = con.createStatement();
            stmt.executeQuery(sql);
            LOGGER.logMessage(LogLevel.WARN, "ERROR ## \u5355\u7ebf\u7a0b" + Thread.currentThread().getName() + "\u5229\u7528sql=" + sql + "\u771f\u6b63\u505a\u6821\u9a8c\u8fde\u63a5\u8be5\u6570\u636e\u6e90" + dbIndex + "\u6210\u529f\uff0c\u8017\u65f6\u4e3a:" + (System.currentTimeMillis() - beginTime));
        }
        catch (SQLException e) {
            LOGGER.logMessage(LogLevel.WARN, "WARN ## \u5355\u7ebf\u7a0b{0}\u5229\u7528sql={1}\u771f\u6b63\u505a\u6821\u9a8c\u8fde\u63a5\u8be5\u6570\u636e\u6e90{2}\u5931\u8d25,\u8017\u65f6\u4e3a:{3}ms", (Throwable)e, new Object[]{Thread.currentThread().getName(), sql, dbIndex, System.currentTimeMillis() - beginTime});
            isSussessful = false;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
            }
        }
        return isSussessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceRange tryOnFailedDataSource(int index, String sequenceName, long minValue, long maxValue, int innerStep, int outStep, List<Integer> excludeIndexes) {
        boolean isTry;
        boolean bl = isTry = System.currentTimeMillis() - this.lastRetryTime > 30000L;
        if (isTry && this.lock.tryLock()) {
            try {
                boolean isSussessful = this.tryToConnectDataBase(index);
                if (!isSussessful) {
                    excludeIndexes.add(index);
                    SequenceRange sequenceRange = null;
                    return sequenceRange;
                }
                this.isAvailable = true;
                this.exceptionTimes = 0;
                SequenceRange sequenceRange = this.tryOnAvailableDataSource(index, sequenceName, maxValue, minValue, outStep, innerStep, excludeIndexes);
                return sequenceRange;
            }
            catch (SequenceException e) {
                LOGGER.logMessage(LogLevel.WARN, "WARN ## \u5355\u7ebf\u7a0b{0}\u5c1d\u8bd5\u6545\u969c\u6570\u636e\u6e90{1}\u65f6\u5931\u8d25\uff0c\u73b0\u5728\u53bb\u5bfb\u627e\u5176\u4ed6\u53ef\u7528\u7684\u6570\u636e\u6e90\uff01", new Object[]{Thread.currentThread().getName(), index});
                excludeIndexes.add(index);
                SequenceRange sequenceRange = null;
                return sequenceRange;
            }
            finally {
                this.lastRetryTime = System.currentTimeMillis();
                this.lock.unlock();
            }
        }
        excludeIndexes.add(index);
        return null;
    }

    private synchronized void calculateExceptionTimes(int index) {
        long currentTime;
        if (!this.isAvailable) {
            LOGGER.logMessage(LogLevel.WARN, "WARN ## \u6570\u636e\u6e90{0}\u5df2\u7ecf\u4e0d\u53ef\u7528\u4e86\uff0c\u4e0d\u7528\u518d\u7edf\u8ba1\u5f02\u5e38\u6b21\u6570\u4e86\uff01", new Object[]{index});
            return;
        }
        if (this.exceptionTimes == 0) {
            this.firstExceptionTime = System.currentTimeMillis();
        }
        if ((currentTime = System.currentTimeMillis()) - this.firstExceptionTime <= 300000L) {
            ++this.exceptionTimes;
            LOGGER.logMessage(LogLevel.WARN, "WARN ## \u6570\u636e\u6e90{0}\u5355\u4f4d\u65f6\u95f4\u5185\u7b2c{1}\u6b21\u5f02\u5e38\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{2}\uff0c\u9996\u6b21\u5f02\u5e38\u65f6\u95f4\uff1a{3}\uff0c\u65f6\u95f4\u95f4\u9694\u4e3a\uff1a{4}ms.", new Object[]{index, this.exceptionTimes, this.getCurrentDateTime(currentTime), this.getCurrentDateTime(this.firstExceptionTime), currentTime - this.firstExceptionTime});
            if (this.exceptionTimes >= 20) {
                this.isAvailable = false;
                LOGGER.logMessage(LogLevel.WARN, "WARN ## \u6570\u636e\u6e90{0}\u5728\u65f6\u95f4{1}\u88ab\u8e22\u51fa", new Object[]{index, this.getCurrentDateTime(null)});
            }
        } else {
            LOGGER.logMessage(LogLevel.WARN, "WARN ## \u7edf\u8ba1\u5f02\u5e38\u6b21\u6570\u8d85\u8fc7\u5355\u4f4d\u65f6\u95f4\u95f4\u9694,\u4e0a\u6b21\u5355\u4f4d\u65f6\u95f4\u95f4\u9694\u5185\u5f02\u5e38\u6b21\u6570\u4e3a{0}\u6b21,\u73b0\u5728\u5f00\u59cb\u91cd\u65b0\u8ba1\u6570\uff01", new Object[]{this.exceptionTimes});
            this.exceptionTimes = 0;
        }
    }

    public void initSequenceRecord(int index, String sequenceName, int innerStep, int outStep, long minValue, long maxValue, String valueColumnName) throws SequenceException {
        block17: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.ds.getConnection();
                stmt = con.prepareStatement(this.selectSql);
                stmt.setString(1, sequenceName);
                rs = stmt.executeQuery();
                int rowNum = 0;
                if (rs.next()) {
                    ++rowNum;
                    long oldValue = rs.getLong(valueColumnName);
                    if (!this.check(index, oldValue, innerStep, outStep)) {
                        if (this.adjust) {
                            this.adjustUpdate(con, index, oldValue, sequenceName, innerStep, outStep, minValue, maxValue);
                        } else {
                            throw new SequenceException("ERROR ## \u6570\u636e\u6e90{0}\u7684\u521d\u59cb\u503c\u6709\u95ee\u9898,\u8bf7\u68c0\u67e5db\u6216\u8005\u5f00\u542fajust\u5f00\u5173\uff01", index);
                        }
                    }
                }
                if (rowNum != 0) break block17;
                if (this.adjust) {
                    this.adjustInsert(con, index, sequenceName, innerStep, outStep, minValue, maxValue);
                    break block17;
                }
                throw new SequenceException("ERROR ## \u6570\u636e\u6e90{0}\u7684sequence\u540d\u4e3a{1}\u7684\u521d\u59cb\u503c\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5db\u6216\u8005\u5f00\u542fajust\u5f00\u5173\uff01", index, sequenceName);
            }
            catch (SQLException e) {
                throw new SequenceException("ERROR ## \u521d\u59cb\u5316sequence\u5931\u8d25,sequence name={0}", e, sequenceName);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (Exception e) {
                    LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
                }
            }
        }
    }

    private void adjustUpdate(Connection con, int index, long oldValue, String name, int innerStep, int outStep, long minValue, long maxValue) throws SequenceException {
        long newValue = this.getAjustValue(index, oldValue, minValue, maxValue, innerStep, outStep, name, false);
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(this.updateSql);
            stmt.setLong(1, newValue);
            stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            stmt.setString(3, name);
            stmt.setLong(4, oldValue);
            int affectedRows = stmt.executeUpdate();
            if (affectedRows == 0) {
                throw new SequenceException("ERROR ## update the record failed!", new Object[0]);
            }
        }
        catch (Exception e) {
            throw new SequenceException("ERROR ## \u66f4\u65b0 sequence \u51fa\u9519,datasouce index={0},sequence name={1},oldvalue={2},newValue={3}", e, index, name, oldValue, newValue);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustInsert(Connection con, int index, String name, int innerStep, int outStep, long minValue, long maxValue) throws SQLException, SequenceException {
        block13: {
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement(this.insertSql);
                stmt.setString(1, name);
                long value = this.getAjustValue(index, minValue, minValue, maxValue, innerStep, outStep, name, false);
                stmt.setLong(2, value);
                stmt.setLong(3, minValue);
                stmt.setLong(4, maxValue);
                stmt.setInt(5, innerStep);
                stmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                stmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                if (this.isHaveInserted(con, name)) {
                    LOGGER.logMessage(LogLevel.WARN, "WARN ## The record has inserted, name={0}", new Object[]{name});
                    break block13;
                }
                throw new SequenceException("ERROR ## the record is not insert to db,name={0}", e, name);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e) {
                    LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHaveInserted(Connection con, String sequenceName) {
        boolean isHaveInserted = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(this.selectSql);
            stmt.setString(1, sequenceName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                isHaveInserted = true;
            }
        }
        catch (SQLException e) {
            LOGGER.logMessage(LogLevel.WARN, "WARN ## select the record error,sequence name={0}", new Object[]{sequenceName});
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("ERROR ## close resources has an error", (Throwable)e, new Object[0]);
            }
        }
        return isHaveInserted;
    }

    private boolean check(int index, long value, int innerStep, int outStep) {
        return value % (long)outStep == (long)(index * innerStep);
    }

    private String getCurrentDateTime(Long time) {
        Date now = time != null ? new Date(time) : new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(now);
    }
}

