/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.servicebasicservice;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.service.registry.ServiceRegistry;
import org.tinygroup.service.registry.ServiceRegistryItem;

public class BasicService {
    private ServiceRegistry serviceRegistry;

    public int getServiceCount() {
        return this.serviceRegistry.getServiceRegistryItems().size();
    }

    public List<ServiceRegistryItem> getServiceRegistryItems() {
        ArrayList<ServiceRegistryItem> list = new ArrayList<ServiceRegistryItem>();
        for (ServiceRegistryItem item : this.serviceRegistry.getServiceRegistryItems()) {
            ServiceRegistryItem newItem = new ServiceRegistryItem();
            newItem.setCategory(item.getCategory());
            newItem.setDescription(item.getDescription());
            newItem.setLocalName(item.getLocalName());
            newItem.setParameters(item.getParameters());
            newItem.setResults(item.getResults());
            newItem.setServiceId(item.getServiceId());
            list.add(newItem);
        }
        return list;
    }

    public ServiceRegistryItem getServiceRegistryItem(String id) {
        ServiceRegistryItem item = this.serviceRegistry.getServiceRegistryItem(id);
        if (item == null) {
            return null;
        }
        ServiceRegistryItem newItem = new ServiceRegistryItem();
        newItem.setCategory(item.getCategory());
        newItem.setDescription(item.getDescription());
        newItem.setLocalName(item.getLocalName());
        newItem.setParameters(item.getParameters());
        newItem.setResults(item.getResults());
        newItem.setServiceId(item.getServiceId());
        return newItem;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

