/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.servicewrapper.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.servicewrapper.ServiceWrapperConfigManager;
import org.tinygroup.servicewrapper.config.MethodConfigs;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class ServiceWrapperFileProcessor
extends AbstractFileProcessor {
    private static final String WRAPPER_CACHE_EXT_FILENAME = ".servicewrapper.xml";
    private ServiceWrapperConfigManager manager;

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(WRAPPER_CACHE_EXT_FILENAME);
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"servicewrapper");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664aop\u670d\u52a1\u5305\u88c5\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            MethodConfigs aopWrappers = (MethodConfigs)this.caches.get(fileObject.getAbsolutePath());
            if (aopWrappers != null) {
                this.manager.removeServiceWrappers(aopWrappers);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664aop\u670d\u52a1\u5305\u88c5\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7daop\u670d\u52a1\u5305\u88c5\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            MethodConfigs oldConfigs = (MethodConfigs)this.caches.get(fileObject.getAbsolutePath());
            if (oldConfigs != null) {
                this.manager.removeServiceWrappers(oldConfigs);
            }
            InputStream inputStream = fileObject.getInputStream();
            MethodConfigs configs = (MethodConfigs)stream.fromXML(inputStream);
            this.manager.addServiceWrappers(configs);
            this.caches.put(fileObject.getAbsolutePath(), configs);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7daop\u670d\u52a1\u5305\u88c5\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    public ServiceWrapperConfigManager getManager() {
        return this.manager;
    }

    public void setManager(ServiceWrapperConfigManager manager) {
        this.manager = manager;
    }
}

