/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.servicewrapper.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.core.annotation.AnnotationUtils;
import org.tinygroup.servicewrapper.ServiceIdAnaly;
import org.tinygroup.servicewrapper.ServiceWrapperConfigManager;
import org.tinygroup.servicewrapper.annotation.ServiceWrapper;
import org.tinygroup.servicewrapper.config.MethodConfig;
import org.tinygroup.servicewrapper.config.ParameterType;

public class DefaultServiceIdAnaly
implements ServiceIdAnaly {
    private ServiceWrapperConfigManager manager;

    public ServiceWrapperConfigManager getManager() {
        return this.manager;
    }

    public void setManager(ServiceWrapperConfigManager manager) {
        this.manager = manager;
    }

    public String analyMethod(Method method) {
        ServiceWrapper serviceWrapper;
        String serviceId = this.manager.getServiceIdWithMethod(method);
        if (serviceId == null && (serviceId = (serviceWrapper = (ServiceWrapper)AnnotationUtils.findAnnotation((Method)method, ServiceWrapper.class)) == null ? method.getName() : serviceWrapper.serviceId()) != null) {
            MethodConfig methodConfig = this.createMethodConfig(method);
            methodConfig.setServiceId(serviceId);
            this.manager.putServiceWrapper(methodConfig);
        }
        return serviceId;
    }

    private MethodConfig createMethodConfig(Method method) {
        MethodConfig serviceWrapperConfig = new MethodConfig();
        serviceWrapperConfig.setType(method.getDeclaringClass().getName());
        serviceWrapperConfig.setMethodName(method.getName());
        Class<?>[] types = method.getParameterTypes();
        ArrayList<ParameterType> parameterTypeList = new ArrayList<ParameterType>();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            ParameterType ptype = new ParameterType();
            ptype.setType(type.getName());
            parameterTypeList.add(ptype);
        }
        serviceWrapperConfig.setParamTypes(parameterTypeList);
        return serviceWrapperConfig;
    }
}

