/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.springmerge;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.tinygroup.springmerge.MergeObject;
import org.tinygroup.springmerge.MergeObjectB;
import org.tinygroup.springmerge.RefObject;
import org.tinygroup.springmerge.beanfactory.SpringMergeApplicationContext;

public class SpringMergeTest
extends TestCase {
    private static SpringMergeApplicationContext applicationContext;
    private static boolean isInited;

    protected void setUp() throws Exception {
        super.setUp();
        if (!isInited) {
            applicationContext = new SpringMergeApplicationContext(this.loadMergeBeanDefinition());
            applicationContext.setConfigLocation("classpath:test.xml");
            applicationContext.refresh();
            isInited = true;
        }
    }

    private BeanDefinitionRegistry loadMergeBeanDefinition() {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        Resource resource = resourceLoader.getResource("MERGE-INFO/merge.xml");
        Object registry = null;
        registry = resource.exists() ? new XmlBeanFactory(resource) : new DefaultListableBeanFactory();
        return registry;
    }

    public void testStringMerge() {
        MergeObject mergeObject = (MergeObject)applicationContext.getBean("stringMerge");
        SpringMergeTest.assertEquals((String)"jpg,docx,png", (String)mergeObject.getSuffix());
    }

    public void testRefMerge() {
        MergeObject mergeObject = (MergeObject)applicationContext.getBean("mergeObject");
        RefObject refObject = mergeObject.getRefObject();
        SpringMergeTest.assertEquals((String)refObject.getName(), (String)"2");
    }

    public void testCollectionMerge() {
        MergeObject mergeObject = (MergeObject)applicationContext.getBean("mergeObject");
        Map<String, String> map = mergeObject.getParamsMap();
        SpringMergeTest.assertEquals((int)5, (int)map.size());
        SpringMergeTest.assertEquals((String)"value11", (String)map.get("key1"));
        SpringMergeTest.assertEquals((String)"value5", (String)map.get("key5"));
        Set<String> set = mergeObject.getParamSet();
        SpringMergeTest.assertEquals((int)5, (int)set.size());
        HashSet<String> expectedset = new HashSet<String>();
        expectedset.add("svalue1");
        expectedset.add("svalue2");
        expectedset.add("svalue3");
        expectedset.add("svalue4");
        expectedset.add("svalue5");
        Iterator expectedsetiter = expectedset.iterator();
        while (expectedsetiter.hasNext()) {
            SpringMergeTest.assertTrue((boolean)set.contains(expectedsetiter.next()));
        }
        List<String> list = mergeObject.getParamList();
        for (String l : list) {
            System.out.println(l);
        }
        SpringMergeTest.assertEquals((int)6, (int)list.size());
        ArrayList<String> expectedlist = new ArrayList<String>();
        expectedlist.add("lvalue1");
        expectedlist.add("lvalue2");
        expectedlist.add("lvalue3");
        expectedlist.add("lvalue11");
        expectedlist.add("lvalue4");
        expectedlist.add("lvalue5");
        for (int i = 0; i < expectedlist.size(); ++i) {
            SpringMergeTest.assertEquals((String)list.get(i), (String)((String)expectedlist.get(i)));
        }
        Properties properties = mergeObject.getProperties();
        SpringMergeTest.assertEquals((int)5, (int)properties.size());
        Properties expectedProp = new Properties();
        for (Object key : expectedProp.keySet()) {
            SpringMergeTest.assertEquals((Object)expectedProp.get(key), (Object)properties.get(key));
        }
    }

    public void testCollectionOverride() {
        MergeObject mergeObject = (MergeObject)applicationContext.getBean("mergeObjectOverride");
        Map<String, String> map = mergeObject.getParamsMap();
        SpringMergeTest.assertEquals((int)map.size(), (int)3);
        SpringMergeTest.assertEquals((String)"value11", (String)map.get("key1"));
        SpringMergeTest.assertEquals((String)"value4", (String)map.get("key4"));
        SpringMergeTest.assertEquals((String)"value5", (String)map.get("key5"));
        SpringMergeTest.assertNull((Object)map.get("key2"));
        SpringMergeTest.assertNull((Object)map.get("key3"));
        Set<String> set = mergeObject.getParamSet();
        SpringMergeTest.assertEquals((int)3, (int)set.size());
        HashSet<String> expectedset = new HashSet<String>();
        expectedset.add("svalue11");
        expectedset.add("svalue4");
        expectedset.add("svalue5");
        Iterator expectedsetiter = expectedset.iterator();
        while (expectedsetiter.hasNext()) {
            SpringMergeTest.assertTrue((boolean)set.contains(expectedsetiter.next()));
        }
        List<String> list = mergeObject.getParamList();
        SpringMergeTest.assertEquals((int)3, (int)list.size());
        ArrayList<String> expectedlist = new ArrayList<String>();
        expectedlist.add("lvalue11");
        expectedlist.add("lvalue4");
        expectedlist.add("lvalue5");
        for (int i = 0; i < expectedlist.size(); ++i) {
            SpringMergeTest.assertEquals((String)list.get(i), (String)((String)expectedlist.get(i)));
        }
        Properties properties = mergeObject.getProperties();
        SpringMergeTest.assertEquals((int)3, (int)properties.size());
        Properties expctedProp = new Properties();
        expctedProp.put("pkey1", "pvalue11");
        expctedProp.put("pkey4", "pvalue4");
        expctedProp.put("pkey5", "pvalue5");
        for (Object key : expctedProp.keySet()) {
            SpringMergeTest.assertEquals((Object)expctedProp.get(key), (Object)properties.get(key));
        }
    }

    public void testClassMerge() {
        SpringMergeTest.assertTrue((boolean)(applicationContext.getBean("classMerge") instanceof MergeObjectB));
        MergeObjectB mergeObject = (MergeObjectB)applicationContext.getBean("classMerge");
        MergeObjectB mergeObjectB = (MergeObjectB)applicationContext.getBean("classMerge");
        SpringMergeTest.assertNotSame((Object)mergeObject, (Object)mergeObjectB);
        SpringMergeTest.assertEquals((String)mergeObject.getSuffix(), (String)"jpg2,pdf2");
        Map<String, String> map = mergeObject.getParamsMap();
        SpringMergeTest.assertEquals((int)map.size(), (int)3);
        SpringMergeTest.assertEquals((String)"value11", (String)map.get("key1"));
        SpringMergeTest.assertEquals((String)"value4", (String)map.get("key4"));
        SpringMergeTest.assertEquals((String)"value5", (String)map.get("key5"));
    }
}

