/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template;

import java.util.Locale;
import org.tinygroup.template.I18nVisitor;
import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.TemplateFunction;
import org.tinygroup.template.function.AbstractBindTemplateFunction;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.loader.StringResourceLoader;

public class TemplateTestCase {
    public static void main(String[] args) throws TemplateException {
        TemplateEngineDefault engine = new TemplateEngineDefault();
        engine.addTemplateFunction((TemplateFunction)new StringBoldFunction());
        engine.setI18nVisitor((I18nVisitor)new I18nvi());
        StringResourceLoader resourceLoader = new StringResourceLoader();
        engine.addResourceLoader((ResourceLoader)resourceLoader);
        Template template = null;
        template = resourceLoader.createTemplate("${'abc'.equals('a')}");
        template.render();
        template = resourceLoader.createTemplate("${fmt('add%sinfo',3)}");
        template.render();
    }

    static class StringBoldFunction
    extends AbstractBindTemplateFunction {
        public StringBoldFunction() {
            super("bold", "java.lang.String");
        }

        public Object execute(Template template, TemplateContext context, Object ... parameters) throws TemplateException {
            String obj = (String)parameters[0];
            return "<b>" + obj + "</b>";
        }
    }

    static class I18nvi
    implements I18nVisitor {
        I18nvi() {
        }

        public Locale getLocale(TemplateContext context) {
            return Locale.getDefault();
        }

        public String getI18nMessage(TemplateContext context, String key) {
            return key.toUpperCase();
        }
    }
}

