/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.tinygroup.template.Macro;
import org.tinygroup.template.TemplateExceptionInfo;
import org.tinygroup.template.TemplateExceptionInfoFormater;
import org.tinygroup.template.interpret.AbstractTemplateExceptionInfo;
import org.tinygroup.template.interpret.DefaultExceptionInfo;
import org.tinygroup.template.interpret.DefaultExceptionInfoFormater;
import org.tinygroup.template.interpret.MacroExceptionInfo;

public class TemplateException
extends Exception {
    private static final long serialVersionUID = -7478199180490496722L;
    protected List<TemplateExceptionInfo> exceptionInfos = new ArrayList<TemplateExceptionInfo>();
    protected String detailMessage = null;
    private TemplateExceptionInfoFormater templateExceptionInfoFormater;

    public TemplateException() {
    }

    public TemplateException(String msg) {
        super(msg);
        this.detailMessage = msg;
    }

    public TemplateException(Throwable throwable) {
        super(throwable);
        this.copyExceptionInfos(throwable);
    }

    public TemplateException(Throwable throwable, ParserRuleContext context, String fileInfo) {
        this(throwable);
        this.updateExceptionInfo(context, fileInfo);
    }

    public TemplateException(String msg, ParserRuleContext context, String fileInfo) {
        super(msg);
        this.detailMessage = msg;
        this.updateExceptionInfo(context, fileInfo);
    }

    public TemplateExceptionInfoFormater getTemplateExceptionInfoFormater() {
        if (this.templateExceptionInfoFormater == null) {
            this.templateExceptionInfoFormater = new DefaultExceptionInfoFormater();
        }
        return this.templateExceptionInfoFormater;
    }

    public void setTemplateExceptionInfoFormater(TemplateExceptionInfoFormater templateExceptionInfoFormater) {
        this.templateExceptionInfoFormater = templateExceptionInfoFormater;
    }

    protected void copyExceptionInfos(Throwable throwable) {
        if (throwable instanceof TemplateException) {
            TemplateException e = (TemplateException)throwable;
            this.exceptionInfos = e.exceptionInfos;
        }
    }

    public void updateExceptionInfo(ParserRuleContext context, String fileInfo) {
        if (fileInfo != null) {
            if (this.exceptionInfos.isEmpty()) {
                this.exceptionInfos.add(new DefaultExceptionInfo(context, this.detailMessage, fileInfo));
            } else {
                AbstractTemplateExceptionInfo info = (AbstractTemplateExceptionInfo)this.exceptionInfos.get(this.exceptionInfos.size() - 1);
                if (!info.getFileInfo().equals(fileInfo)) {
                    this.exceptionInfos.add(new DefaultExceptionInfo(context, this.detailMessage, fileInfo));
                }
            }
        }
    }

    public List<TemplateExceptionInfo> getExceptionInfos() {
        return this.exceptionInfos;
    }

    public TemplateExceptionInfo getExceptionInfo() {
        if (this.exceptionInfos != null && !this.exceptionInfos.isEmpty()) {
            return this.exceptionInfos.get(0);
        }
        return null;
    }

    public void recombine() {
        HashMap<String, Macro> macroMaps = new HashMap<String, Macro>();
        for (TemplateExceptionInfo info : this.exceptionInfos) {
            if (!info.isMacroException()) continue;
            macroMaps.put(info.getMacroInfo().getMacroPath(), info.getMacroInfo());
        }
        ArrayList<TemplateExceptionInfo> list = new ArrayList<TemplateExceptionInfo>();
        for (TemplateExceptionInfo info : this.exceptionInfos) {
            if (info instanceof AbstractTemplateExceptionInfo) {
                AbstractTemplateExceptionInfo ainfo = (AbstractTemplateExceptionInfo)info;
                if (macroMaps.containsKey(ainfo.getFileInfo())) {
                    list.add(0, new MacroExceptionInfo(ainfo.getParserRuleContext(), ainfo.getReason(), ainfo.getFileInfo(), (Macro)macroMaps.get(ainfo.getFileInfo())));
                    continue;
                }
                list.add(0, new DefaultExceptionInfo(ainfo.getParserRuleContext(), ainfo.getReason(), ainfo.getFileInfo()));
                continue;
            }
            list.add(info);
        }
        this.exceptionInfos = list;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        for (TemplateExceptionInfo info : this.exceptionInfos) {
            sb.append(this.getTemplateExceptionInfoFormater().getMessage(info));
        }
        return sb.toString();
    }
}

