/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.fileresolver;

import java.util.List;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.ProcessorCallBack;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.fileresolver.impl.MultiThreadFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.template.Macro;
import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.loader.FileObjectResourceLoader;
import org.tinygroup.template.loader.FileResourceManager;
import org.tinygroup.template.loader.TemplateLoadUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;

public class TinyMacroFileProcessor
extends AbstractFileProcessor {
    private static final String TINY_TEMPLATE_CONFIG = "/application/template-config";
    private static final String TINY_TEMPLATE_CONFIG_PATH = "/templateconfig.config.xml";
    private static final String TEMPLATE_EXT_FILE_NAME = "templateExtFileName";
    private static final String LAYOUT_EXT_FILE_NAME = "layoutExtFileName";
    private static final String COMPONENT_EXT_FILE_NAME = "componentExtFileName";
    private static final String THREAD_NUM = "threadNum";
    private static final String SYN_LOAD = "synLoad";
    private static final String TEXT_ORDER_BY_TIME = "textOrderByTime";
    private static final String THROW_LEXER_ERROR = "throwLexerError";
    private static final String TEMPLATE_EXT_DEFALUT = "page";
    private static final String LAYOUT_EXT_DEFALUT = "layout";
    private static final String COMPONENT_EXT_DEFALUT = "component";
    private String templateExtFileName;
    private String layoutExtFileName;
    private String componentExtFileName;
    private boolean initTag = false;
    private boolean synLoad = true;
    private TemplateEngine engine;
    private FileResourceManager fileResourceManager;
    private int threadNum = Runtime.getRuntime().availableProcessors();
    private boolean textOrderByTime = false;
    private boolean throwLexerError = false;

    public TemplateEngine getEngine() {
        return this.engine;
    }

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    public FileResourceManager getFileResourceManager() {
        return this.fileResourceManager;
    }

    public void setFileResourceManager(FileResourceManager fileResourceManager) {
        this.fileResourceManager = fileResourceManager;
    }

    public boolean checkMatch(FileObject fileObject) {
        this.init();
        return this.isPage(fileObject.getFileName()) || this.isLayout(fileObject.getFileName()) || this.isComponent(fileObject.getFileName());
    }

    private boolean isPage(String fileName) {
        return fileName.endsWith("." + this.templateExtFileName);
    }

    private boolean isLayout(String fileName) {
        return fileName.endsWith("." + this.layoutExtFileName);
    }

    private boolean isComponent(String fileName) {
        return fileName.endsWith("." + this.componentExtFileName);
    }

    private void init() {
        if (!this.initTag) {
            this.reloadTemplateConfig();
            this.initTag = true;
        }
    }

    public void process() {
        if (this.synLoad) {
            this.synProcess();
        } else {
            this.nonSynProcess();
        }
    }

    private void synProcess() {
        if (this.deleteList != null && !this.deleteList.isEmpty()) {
            this.deleteTemplate();
        }
        if (this.changeList != null && !this.changeList.isEmpty()) {
            this.updateTemplate();
        }
    }

    private void nonSynProcess() {
        if (this.deleteList != null && !this.deleteList.isEmpty()) {
            new Thread(new DeleteTemplateThread()).start();
        }
        if (this.changeList != null && !this.changeList.isEmpty()) {
            new Thread(new UpdateTemplateThread()).start();
        }
    }

    private synchronized void reloadTemplateConfig() {
        XmlNode totalConfig = ConfigurationUtil.combineXmlNode((XmlNode)this.applicationConfig, (XmlNode)this.componentConfig);
        this.templateExtFileName = TEMPLATE_EXT_DEFALUT;
        this.layoutExtFileName = LAYOUT_EXT_DEFALUT;
        this.componentExtFileName = COMPONENT_EXT_DEFALUT;
        if (totalConfig != null) {
            this.templateExtFileName = StringUtil.defaultIfBlank((String)totalConfig.getAttribute(TEMPLATE_EXT_FILE_NAME), (String)TEMPLATE_EXT_DEFALUT);
            this.layoutExtFileName = StringUtil.defaultIfBlank((String)totalConfig.getAttribute(LAYOUT_EXT_FILE_NAME), (String)LAYOUT_EXT_DEFALUT);
            this.componentExtFileName = StringUtil.defaultIfBlank((String)totalConfig.getAttribute(COMPONENT_EXT_FILE_NAME), (String)COMPONENT_EXT_DEFALUT);
            this.threadNum = Integer.parseInt(StringUtil.defaultIfBlank((String)totalConfig.getAttribute(THREAD_NUM), (String)String.valueOf(Runtime.getRuntime().availableProcessors())));
            this.synLoad = Boolean.parseBoolean(StringUtil.defaultIfBlank((String)totalConfig.getAttribute(SYN_LOAD), (String)"true"));
            this.textOrderByTime = Boolean.parseBoolean(StringUtil.defaultIfBlank((String)totalConfig.getAttribute(TEXT_ORDER_BY_TIME), (String)"false"));
            this.throwLexerError = Boolean.parseBoolean(StringUtil.defaultIfBlank((String)totalConfig.getAttribute(THROW_LEXER_ERROR), (String)"false"));
        }
        boolean addTag = true;
        for (ResourceLoader loader : this.engine.getResourceLoaderList()) {
            if (!(loader instanceof FileObjectResourceLoader)) continue;
            addTag = false;
            break;
        }
        this.fileResourceManager.setFileResolver(this.fileResolver);
        this.fileResourceManager.setTextOrderByTime(this.textOrderByTime);
        if (addTag) {
            FileObjectResourceLoader fileObjectResourceLoader = new FileObjectResourceLoader(this.templateExtFileName, this.layoutExtFileName, this.componentExtFileName);
            fileObjectResourceLoader.setFileResourceManager(this.fileResourceManager);
            this.engine.addResourceLoader(fileObjectResourceLoader);
        }
        if (this.engine instanceof TemplateEngineDefault) {
            TemplateEngineDefault templateEngine = (TemplateEngineDefault)this.engine;
            templateEngine.setThrowLexerError(this.throwLexerError);
        }
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        super.config(applicationConfig, componentConfig);
    }

    public String getComponentConfigPath() {
        return TINY_TEMPLATE_CONFIG_PATH;
    }

    public String getApplicationNodePath() {
        return TINY_TEMPLATE_CONFIG;
    }

    private void updateTemplate() {
        int runThreadNum = this.changeList.size() > this.threadNum ? this.threadNum : this.changeList.size();
        MultiThreadFileProcessor.multiProcessor((int)runThreadNum, (String)"updateTemplate-muti", (List)this.changeList, (ProcessorCallBack)new ProcessorCallBack(){

            public void callBack(FileObject fileObject) {
                LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u5f00\u59cb\u52a0\u8f7d", new Object[]{fileObject.getAbsolutePath()});
                try {
                    TinyMacroFileProcessor.this.fileResourceManager.addResource(fileObject.getPath(), fileObject);
                    Template template = TinyMacroFileProcessor.this.engine.findTemplateCache(fileObject.getPath(), fileObject.getAbsolutePath());
                    if (template != null) {
                        if (TinyMacroFileProcessor.this.isComponent(fileObject.getFileName())) {
                            for (Macro macro : template.getMacroMap().values()) {
                                TinyMacroFileProcessor.this.engine.removeMacroCache(macro.getName(), macro.getAbsolutePath());
                            }
                        }
                        TinyMacroFileProcessor.this.engine.removeTemplateCache(fileObject.getPath(), fileObject.getAbsolutePath());
                    }
                    template = TemplateLoadUtil.loadComponent((TemplateEngineDefault)TinyMacroFileProcessor.this.engine, fileObject);
                    template.setTemplateEngine(TinyMacroFileProcessor.this.engine);
                    TinyMacroFileProcessor.this.engine.addTemplateCache(template.getPath(), template);
                    if (TinyMacroFileProcessor.this.isComponent(fileObject.getFileName())) {
                        TinyMacroFileProcessor.this.engine.registerMacroLibrary(template);
                    }
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u52a0\u8f7d\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u51fa\u9519,\u6ce8\u518c\u4e3b\u952e[{1}]", (Throwable)e, new Object[]{fileObject.getAbsolutePath(), fileObject.getPath()});
                }
                LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u52a0\u8f7d\u5b8c\u6bd5,\u6ce8\u518c\u4e3b\u952e[{1}]", new Object[]{fileObject.getAbsolutePath(), fileObject.getPath()});
            }
        });
    }

    private void deleteTemplate() {
        int runThreadNum = this.deleteList.size() > this.threadNum ? this.threadNum : this.deleteList.size();
        MultiThreadFileProcessor.multiProcessor((int)runThreadNum, (String)"deleteTemplate-muti", (List)this.deleteList, (ProcessorCallBack)new ProcessorCallBack(){

            public void callBack(FileObject fileObject) {
                LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u5f00\u59cb\u79fb\u9664", new Object[]{fileObject.getAbsolutePath()});
                try {
                    TinyMacroFileProcessor.this.fileResourceManager.removeResource(fileObject);
                    Template template = TinyMacroFileProcessor.this.engine.findTemplateCache(fileObject.getPath(), fileObject.getAbsolutePath());
                    if (template != null) {
                        if (TinyMacroFileProcessor.this.isComponent(fileObject.getFileName())) {
                            for (Macro macro : template.getMacroMap().values()) {
                                TinyMacroFileProcessor.this.engine.removeMacroCache(macro.getName(), macro.getAbsolutePath());
                            }
                        }
                        TinyMacroFileProcessor.this.engine.removeTemplateCache(template.getPath(), template.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u79fb\u9664\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u51fa\u9519,\u5378\u8f7d\u4e3b\u952e[{1}]", (Throwable)e, new Object[]{fileObject.getAbsolutePath(), fileObject.getPath()});
                }
                LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u79fb\u9664\u5b8c\u6bd5,\u5378\u8f7d\u4e3b\u952e[{1}]", new Object[]{fileObject.getAbsolutePath(), fileObject.getPath()});
            }
        });
    }

    class DeleteTemplateThread
    implements Runnable {
        DeleteTemplateThread() {
        }

        @Override
        public void run() {
            TinyMacroFileProcessor.this.deleteTemplate();
        }
    }

    class UpdateTemplateThread
    implements Runnable {
        UpdateTemplateThread() {
        }

        @Override
        public void run() {
            TinyMacroFileProcessor.this.updateTemplate();
        }
    }
}

