/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.function;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.function.AbstractTemplateFunction;
import org.tinygroup.template.loader.StringResourceLoader;

public class EvaluateTemplateFunction
extends AbstractTemplateFunction {
    public EvaluateTemplateFunction() {
        super("eval,evaluate");
    }

    @Override
    public Object execute(Template template, TemplateContext context, Object ... parameters) throws TemplateException {
        if (parameters.length == 0 || parameters[0] == null) {
            return null;
        }
        if (!(parameters[0] instanceof String)) {
            this.notSupported(parameters);
        }
        String stringTemplate = parameters[0].toString();
        StringResourceLoader stringResourceLoader = new StringResourceLoader();
        stringResourceLoader.setTemplateEngine(this.getTemplateEngine());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        stringResourceLoader.createTemplate(stringTemplate).render(context, outputStream);
        try {
            return new String(outputStream.toByteArray(), template.getTemplateEngine().getEncode());
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateException(e);
        }
    }
}

