/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.function;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.function.AbstractTemplateFunction;

public class FormatDateFunction
extends AbstractTemplateFunction {
    public static final String DEFAULT_PATTEN = "yyyy-MM-dd HH:mm:ss";

    public FormatDateFunction() {
        super("formatDate,formatdate");
    }

    @Override
    public Object execute(Template template, TemplateContext context, Object ... parameters) throws TemplateException {
        if (parameters == null || parameters.length < 1 || parameters[0] == null) {
            return "";
        }
        String patten = parameters.length > 1 ? (String)parameters[1] : DEFAULT_PATTEN;
        SimpleDateFormat format = new SimpleDateFormat(patten);
        return format.format(this.getSource(parameters[0]));
    }

    private Object getSource(Object obj) {
        if (obj instanceof Long) {
            Long time = (Long)obj;
            return new Date(time);
        }
        if (obj instanceof String) {
            Long time = Long.parseLong((String)obj);
            return new Date(time);
        }
        return obj;
    }
}

