/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.function;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.function.AbstractTemplateFunction;

public class ParseTemplateFunction
extends AbstractTemplateFunction {
    public ParseTemplateFunction() {
        super("parse");
    }

    @Override
    public Object execute(Template template, TemplateContext context, Object ... parameters) throws TemplateException {
        if (parameters.length == 0 || !(parameters[0] instanceof String)) {
            this.notSupported(parameters);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String path = parameters[0].toString();
        try {
            if (!path.startsWith("/")) {
                URL url = new URL("file:" + template.getPath());
                URL newUrl = new URL(url, path);
                path = newUrl.getPath();
            }
            template.getTemplateEngine().renderTemplateWithOutLayout(path, context, outputStream);
            return new String(outputStream.toByteArray(), template.getTemplateEngine().getEncode());
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateException(e);
        }
        catch (MalformedURLException e) {
            throw new TemplateException(e);
        }
    }
}

