/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.function;

import java.util.Random;
import java.util.UUID;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.function.AbstractTemplateFunction;

public class RandomFunction
extends AbstractTemplateFunction {
    public RandomFunction() {
        super("rand,random");
    }

    @Override
    public Object execute(Template template, TemplateContext context, Object ... parameters) throws TemplateException {
        if (parameters == null || parameters.length < 1) {
            return this.nextInt();
        }
        String type = (String)parameters[0];
        if (type == null || type.equalsIgnoreCase("int")) {
            return this.nextInt();
        }
        if (type.equalsIgnoreCase("long")) {
            return this.nextLong();
        }
        if (type.equalsIgnoreCase("uuid")) {
            return this.nextUUID();
        }
        if (type.equalsIgnoreCase("double")) {
            return this.nextDouble();
        }
        if (type.equalsIgnoreCase("float")) {
            return this.nextFloat();
        }
        return null;
    }

    private Integer nextInt() {
        Random r = new Random();
        return Math.abs(r.nextInt());
    }

    private Long nextLong() {
        Random r = new Random();
        return Math.abs(r.nextLong());
    }

    private Float nextFloat() {
        Random r = new Random();
        return Float.valueOf(Math.abs(r.nextFloat()));
    }

    private Double nextDouble() {
        Random r = new Random();
        return Math.abs(r.nextDouble());
    }

    private String nextUUID() {
        return UUID.randomUUID().toString();
    }
}

