/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.function.escape;

import org.apache.commons.lang.StringUtils;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.function.AbstractTemplateFunction;

public abstract class AbstractEscapeFunction
extends AbstractTemplateFunction {
    protected String[] searchWords;
    protected String[] replaceWords;

    public String[] getSearchWords() {
        return this.searchWords;
    }

    public void setSearchWords(String[] searchWords) {
        this.searchWords = searchWords;
    }

    public String[] getReplaceWords() {
        return this.replaceWords;
    }

    public void setReplaceWords(String[] replaceWords) {
        this.replaceWords = replaceWords;
    }

    public AbstractEscapeFunction(String names) {
        super(names);
    }

    @Override
    public Object execute(Template template, TemplateContext context, Object ... parameters) throws TemplateException {
        if (parameters == null || parameters.length < 1) {
            throw new TemplateException(String.format("\u51fd\u6570%s\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e.", this.getNames()));
        }
        if (parameters[0] == null) {
            return null;
        }
        String content = parameters[0].toString();
        if (StringUtil.isEmpty((String)content)) {
            return content;
        }
        return this.replace(content);
    }

    protected String replace(String content) throws TemplateException {
        try {
            return StringUtils.replaceEach((String)content, (String[])this.searchWords, (String[])this.replaceWords);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }
}

