/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.template.Macro;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.TemplateContextDefault;

public abstract class AbstractTemplate
implements Template {
    protected TemplateEngine templateEngine;
    private Map<String, Macro> macroMap = new HashMap<String, Macro>();
    private TemplateContext templateContext = new TemplateContextDefault();
    private List<String> importPathList = new ArrayList<String>();
    private long lastModifiedTime;
    private String absolutePath;

    @Override
    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @Override
    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        for (Macro macro : this.macroMap.values()) {
            macro.setTemplateEngine(templateEngine);
        }
    }

    @Override
    public void addImport(Object importPath) {
        this.importPathList.add(importPath.toString());
    }

    @Override
    public List<String> getImportPathList() {
        return this.importPathList;
    }

    public void addMacro(Macro macro) {
        this.macroMap.put(macro.getName(), macro);
        macro.setTemplateEngine(this.getTemplateEngine());
    }

    @Override
    public Map<String, Macro> getMacroMap() {
        return this.macroMap;
    }

    @Override
    public void render(TemplateContext context, OutputStream outputStream) throws TemplateException {
        try {
            this.renderContent(context, outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
        finally {
            context.removeSubContext("$currentTemplateContext");
        }
    }

    @Override
    public void render(TemplateContext context) throws TemplateException {
        this.render(context, System.out);
    }

    @Override
    public void render() throws TemplateException {
        this.render(new TemplateContextDefault(), System.out);
    }

    protected abstract void renderContent(TemplateContext var1, OutputStream var2) throws IOException, TemplateException;

    @Override
    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    public Object put(String key, Object value) {
        return this.templateContext.put(key, value);
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public void setLastModifiedTime(long time) {
        this.lastModifiedTime = time;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public void setAbsolutePath(String path) {
        this.absolutePath = path;
    }
}

