/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinygroup.commons.tools.ExceptionUtil;
import org.tinygroup.template.I18nVisitor;
import org.tinygroup.template.Macro;
import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.StaticClassOperator;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateCache;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.TemplateFunction;
import org.tinygroup.template.Updatable;
import org.tinygroup.template.application.DefaultStaticClassOperator;
import org.tinygroup.template.function.CallMacroFunction;
import org.tinygroup.template.function.EvaluateTemplateFunction;
import org.tinygroup.template.function.ExtendMapFunction;
import org.tinygroup.template.function.FormatDateFunction;
import org.tinygroup.template.function.FormatterTemplateFunction;
import org.tinygroup.template.function.GetFunction;
import org.tinygroup.template.function.GetResourceContentFunction;
import org.tinygroup.template.function.I18nFunction;
import org.tinygroup.template.function.InstanceOfTemplateFunction;
import org.tinygroup.template.function.ParseTemplateFunction;
import org.tinygroup.template.function.RandomFunction;
import org.tinygroup.template.function.RenderLayerFunction;
import org.tinygroup.template.function.ToBoolFunction;
import org.tinygroup.template.function.ToDoubleFunction;
import org.tinygroup.template.function.ToFloatFunction;
import org.tinygroup.template.function.ToIntFunction;
import org.tinygroup.template.function.ToLongFunction;
import org.tinygroup.template.function.TodayFunction;
import org.tinygroup.template.function.UrlDecodeFunction;
import org.tinygroup.template.function.UrlEncodeFunction;
import org.tinygroup.template.function.escape.EscapeHtmlFunction;
import org.tinygroup.template.function.escape.UnEscapeHtmlFunction;
import org.tinygroup.template.impl.TemplateCacheDefault;
import org.tinygroup.template.impl.TemplateContextDefault;
import org.tinygroup.template.interpret.TemplateInterpreter;
import org.tinygroup.template.interpret.context.ArrayGetProcessor;
import org.tinygroup.template.interpret.context.ArrayProcessor;
import org.tinygroup.template.interpret.context.BlankProcessor;
import org.tinygroup.template.interpret.context.BodyContentProcessor;
import org.tinygroup.template.interpret.context.CallMacroProcessor;
import org.tinygroup.template.interpret.context.CallMacroWithBodyProcessor;
import org.tinygroup.template.interpret.context.CallProcessor;
import org.tinygroup.template.interpret.context.CallWithBodyProcessor;
import org.tinygroup.template.interpret.context.CommentProcessor;
import org.tinygroup.template.interpret.context.DentProcessor;
import org.tinygroup.template.interpret.context.ElseIfProcessor;
import org.tinygroup.template.interpret.context.EolProcessor;
import org.tinygroup.template.interpret.context.EscapeTextNodeProcessor;
import org.tinygroup.template.interpret.context.ExpressionGroupProcessor;
import org.tinygroup.template.interpret.context.FieldProcessor;
import org.tinygroup.template.interpret.context.ForBreakProcessor;
import org.tinygroup.template.interpret.context.ForContinueProcessor;
import org.tinygroup.template.interpret.context.ForProcessor;
import org.tinygroup.template.interpret.context.FunctionCallProcessor;
import org.tinygroup.template.interpret.context.IfProcessor;
import org.tinygroup.template.interpret.context.ImportIgnoreProcessor;
import org.tinygroup.template.interpret.context.IncludeProcessor;
import org.tinygroup.template.interpret.context.IndentProcessor;
import org.tinygroup.template.interpret.context.LayoutDefineProcessor;
import org.tinygroup.template.interpret.context.LayoutImplementProcessor;
import org.tinygroup.template.interpret.context.MacroDefineIgnoreProcessor;
import org.tinygroup.template.interpret.context.MapListProcessor;
import org.tinygroup.template.interpret.context.MapProcessor;
import org.tinygroup.template.interpret.context.MathBinaryProcessor;
import org.tinygroup.template.interpret.context.MathBinaryShiftProcessor;
import org.tinygroup.template.interpret.context.MathBitwiseProcessor;
import org.tinygroup.template.interpret.context.MathCompareConditionProcessor;
import org.tinygroup.template.interpret.context.MathCompareProcessor;
import org.tinygroup.template.interpret.context.MathCompareRalationProcessor;
import org.tinygroup.template.interpret.context.MathConditionProcessor;
import org.tinygroup.template.interpret.context.MathConditionSimpleProcessor;
import org.tinygroup.template.interpret.context.MathIdentifierProcessor;
import org.tinygroup.template.interpret.context.MathSingleLeftProcessor;
import org.tinygroup.template.interpret.context.MathSingleRightProcessor;
import org.tinygroup.template.interpret.context.MathUnaryProcessor;
import org.tinygroup.template.interpret.context.MemberFunctionCallProcessor;
import org.tinygroup.template.interpret.context.PageContentProcessor;
import org.tinygroup.template.interpret.context.RangeProcessor;
import org.tinygroup.template.interpret.context.ReturnProcessor;
import org.tinygroup.template.interpret.context.SetProcessor;
import org.tinygroup.template.interpret.context.StopProcessor;
import org.tinygroup.template.interpret.context.TabProcessor;
import org.tinygroup.template.interpret.context.TextProcessor;
import org.tinygroup.template.interpret.context.ValueProcessor;
import org.tinygroup.template.interpret.context.WhileProcessor;
import org.tinygroup.template.interpret.terminal.FalseNodeProcessor;
import org.tinygroup.template.interpret.terminal.FloatProcessor;
import org.tinygroup.template.interpret.terminal.IntegerHexNodeProcessor;
import org.tinygroup.template.interpret.terminal.IntegerNodeProcessor;
import org.tinygroup.template.interpret.terminal.IntegerOctNodeProcessor;
import org.tinygroup.template.interpret.terminal.NullNodeProcessor;
import org.tinygroup.template.interpret.terminal.StringDoubleNodeProcessor;
import org.tinygroup.template.interpret.terminal.StringSingleNodeProcessor;
import org.tinygroup.template.interpret.terminal.TextCdataNodeProcessor;
import org.tinygroup.template.interpret.terminal.TextPlainNodeProcessor;
import org.tinygroup.template.interpret.terminal.TrueNodeProcessor;
import org.tinygroup.template.rumtime.TemplateUtil;

public class TemplateEngineDefault
implements TemplateEngine {
    public static final TemplateInterpreter interpreter = new TemplateInterpreter();
    private static Map<String, StaticClassOperator> staticClassOperatorMap = new HashMap<String, StaticClassOperator>();
    private Map<String, TemplateFunction> functionMap = new HashMap<String, TemplateFunction>();
    private Map<Class, Map<String, TemplateFunction>> typeFunctionMap = new HashMap<Class, Map<String, TemplateFunction>>();
    private TemplateContext templateEngineContext;
    private List<ResourceLoader> resourceLoaderList = new ArrayList<ResourceLoader>();
    private String encode = "UTF-8";
    private I18nVisitor i18nVisitor;
    private TemplateCache<String, List<Template>> layoutPathListCache = new TemplateCacheDefault<String, List<Template>>();
    private TemplateCache<String, Object> localeSearchResults = new TemplateCacheDefault<String, Object>();
    private Map<String, Map<String, Template>> templateCache = new ConcurrentHashMap<String, Map<String, Template>>();
    private Map<String, Map<String, Macro>> macroCache = new ConcurrentHashMap<String, Map<String, Macro>>();
    private UpdatableComparator comparator = new UpdatableComparator();
    private boolean checkModified = false;
    private boolean localeTemplateEnable = false;
    private boolean compactMode;
    private boolean throwLexerError = false;

    public TemplateEngineDefault() {
        this.addTemplateFunction(new FormatterTemplateFunction());
        this.addTemplateFunction(new InstanceOfTemplateFunction());
        this.addTemplateFunction(new GetResourceContentFunction());
        this.addTemplateFunction(new EvaluateTemplateFunction());
        this.addTemplateFunction(new CallMacroFunction());
        this.addTemplateFunction(new GetFunction());
        this.addTemplateFunction(new RandomFunction());
        this.addTemplateFunction(new ToIntFunction());
        this.addTemplateFunction(new ToLongFunction());
        this.addTemplateFunction(new ToBoolFunction());
        this.addTemplateFunction(new ToFloatFunction());
        this.addTemplateFunction(new ToDoubleFunction());
        this.addTemplateFunction(new FormatDateFunction());
        this.addTemplateFunction(new TodayFunction());
        this.addTemplateFunction(new ParseTemplateFunction());
        this.addTemplateFunction(new I18nFunction());
        this.addTemplateFunction(new ExtendMapFunction());
        this.addTemplateFunction(new RenderLayerFunction());
        this.addTemplateFunction(new EscapeHtmlFunction());
        this.addTemplateFunction(new UnEscapeHtmlFunction());
        this.addTemplateFunction(new UrlEncodeFunction());
        this.addTemplateFunction(new UrlDecodeFunction());
    }

    private static void addDefaultStaticClassOperator(StaticClassOperator operator) {
        staticClassOperatorMap.put(operator.getName(), operator);
    }

    @Override
    public boolean isLocaleTemplateEnable() {
        return this.localeTemplateEnable;
    }

    @Override
    public void setLocaleTemplateEnable(boolean localeTemplateEnable) {
        this.localeTemplateEnable = localeTemplateEnable;
    }

    @Override
    public boolean isCheckModified() {
        return this.checkModified;
    }

    @Override
    public void setCheckModified(boolean checkModified) {
        this.checkModified = checkModified;
    }

    @Override
    public boolean isSafeVariable() {
        return TemplateUtil.isSafeVariable();
    }

    @Override
    public void setSafeVariable(boolean safeVariable) {
        TemplateUtil.setSafeVariable(safeVariable);
    }

    public TemplateInterpreter getTemplateInterpreter() {
        return interpreter;
    }

    @Override
    public boolean isCompactMode() {
        return this.compactMode;
    }

    @Override
    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public boolean isThrowLexerError() {
        return this.throwLexerError;
    }

    public void setThrowLexerError(boolean throwLexerError) {
        this.throwLexerError = throwLexerError;
    }

    @Override
    public void registerMacroLibrary(String path) throws TemplateException {
        this.registerMacroLibrary(this.getMacroLibrary(path));
    }

    @Override
    public void registerMacro(Macro macro) throws TemplateException {
        this.addMacroCache(macro.getName(), macro);
    }

    @Override
    public void registerMacroLibrary(Template template) throws TemplateException {
        for (Map.Entry<String, Macro> entry : template.getMacroMap().entrySet()) {
            Macro macro = entry.getValue();
            if (macro.getMacroPath() == null) {
                macro.setMacroPath(template.getPath());
            }
            if (macro.getAbsolutePath() == null) {
                macro.setAbsolutePath(template.getAbsolutePath());
            }
            macro.setLastModifiedTime(template.getLastModifiedTime());
            this.registerMacro(entry.getValue());
        }
    }

    @Override
    public void write(OutputStream outputStream, Object data) throws TemplateException {
        try {
            if (data != null) {
                if (data instanceof byte[]) {
                    outputStream.write((byte[])data);
                } else if (data instanceof ByteArrayOutputStream) {
                    outputStream.write(((ByteArrayOutputStream)data).toByteArray());
                } else {
                    outputStream.write(data.toString().getBytes(this.getEncode()));
                }
            }
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    @Override
    public TemplateContext getTemplateContext() {
        if (this.templateEngineContext == null) {
            this.templateEngineContext = new TemplateContextDefault(staticClassOperatorMap);
        }
        return this.templateEngineContext;
    }

    @Override
    public I18nVisitor getI18nVisitor() {
        return this.i18nVisitor;
    }

    @Override
    public TemplateEngineDefault setI18nVisitor(I18nVisitor i18nVistor) {
        this.i18nVisitor = i18nVistor;
        return this;
    }

    @Override
    public TemplateEngineDefault addTemplateFunction(TemplateFunction function) {
        function.setTemplateEngine(this);
        String[] names = function.getNames().split(",");
        if (function.getBindingTypes() == null) {
            for (String name : names) {
                this.functionMap.put(name, function);
            }
        } else {
            String[] types;
            for (String type : types = function.getBindingTypes().split(",")) {
                try {
                    Class<?> clazz = Class.forName(type);
                    Map<String, TemplateFunction> nameMap = this.typeFunctionMap.get(clazz);
                    if (nameMap == null) {
                        nameMap = new HashMap<String, TemplateFunction>();
                        this.typeFunctionMap.put(clazz, nameMap);
                    }
                    for (String name : names) {
                        nameMap.put(name, function);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this;
    }

    @Override
    public TemplateFunction getTemplateFunction(String methodName) {
        return this.functionMap.get(methodName);
    }

    @Override
    public TemplateFunction getTemplateFunction(Object object, String methodName) {
        TemplateFunction function;
        Map<String, TemplateFunction> typeMap = this.typeFunctionMap.get(object.getClass());
        if (typeMap != null && (function = typeMap.get(methodName)) != null) {
            return function;
        }
        for (Class clz : this.typeFunctionMap.keySet()) {
            TemplateFunction function2;
            if (!clz.isInstance(object) || (function2 = this.typeFunctionMap.get(clz).get(methodName)) == null) continue;
            return function2;
        }
        return null;
    }

    @Override
    public String getEncode() {
        return this.encode;
    }

    @Override
    public TemplateEngineDefault setEncode(String encode) {
        this.encode = encode;
        return this;
    }

    @Override
    public TemplateEngineDefault addResourceLoader(ResourceLoader resourceLoader) {
        resourceLoader.setTemplateEngine(this);
        this.resourceLoaderList.add(resourceLoader);
        return this;
    }

    private Template findTemplate(TemplateContext context, String path) throws TemplateException {
        Locale locale;
        if (this.localeTemplateEnable && (locale = (Locale)context.get("defaultLocale")) != null) {
            String localePath = TemplateUtil.getLocalePath(path, locale);
            if (this.localeSearchResults.contains(localePath)) {
                return this.findTemplate(path);
            }
            try {
                Template template = this.findTemplate(localePath);
                if (template != null) {
                    return template;
                }
                this.localeSearchResults.put(localePath, "");
            }
            catch (TemplateException e) {
                this.localeSearchResults.put(localePath, "");
                return this.findTemplate(path);
            }
        }
        return this.findTemplate(path);
    }

    private Template findLayout(TemplateContext context, String path) throws TemplateException {
        Locale locale;
        if (this.localeTemplateEnable && (locale = (Locale)context.get("defaultLocale")) != null) {
            String localePath = TemplateUtil.getLocalePath(path, locale);
            if (this.localeSearchResults.contains(localePath)) {
                return this.findLayout(path, false);
            }
            try {
                Template template = this.findLayout(localePath, false);
                if (template != null) {
                    return template;
                }
                this.localeSearchResults.put(localePath, "");
            }
            catch (TemplateException e) {
                this.localeSearchResults.put(localePath, "");
                return this.findLayout(path, false);
            }
        }
        return this.findLayout(path, false);
    }

    @Override
    public Template findTemplate(String path) throws TemplateException {
        Template template = null;
        if (!this.checkModified && (template = this.findTemplateCache(path)) != null) {
            this.updateTemplate(template);
            return template;
        }
        if (template == null) {
            for (ResourceLoader loader : this.resourceLoaderList) {
                template = loader.getTemplate(path);
                if (template == null) continue;
                this.updateTemplate(template);
                return template;
            }
        }
        throw this.wrapperException("\u627e\u4e0d\u5230\u6a21\u677f\uff1a" + path);
    }

    private TemplateException wrapperException(String error) {
        Exception e = new Exception(error);
        return new TemplateException(e);
    }

    private void updateTemplate(Template template) {
        if (template.getTemplateEngine() == null) {
            template.setTemplateEngine(this);
        }
        if (template.getTemplateContext().getParent() == null) {
            template.getTemplateContext().setParent(this.getTemplateContext());
        }
    }

    @Override
    public void removeTemplate(String path) throws TemplateException {
        Map<String, Template> map = this.templateCache.get(path);
        if (map != null) {
            for (Template template : map.values()) {
                for (Macro macro : template.getMacroMap().values()) {
                    this.removeMacroCache(macro.getName(), macro.getAbsolutePath());
                }
                this.removeTemplateCache(template.getPath(), template.getAbsolutePath());
            }
        }
        this.layoutPathListCache.remove(path);
    }

    public Template findLayout(String path) throws TemplateException {
        return this.findLayout(path, true);
    }

    private Template findLayout(String path, boolean throwException) throws TemplateException {
        Template template = null;
        if (!this.checkModified && (template = this.findTemplateCache(path)) != null) {
            this.updateTemplate(template);
            return template;
        }
        if (template == null) {
            for (ResourceLoader loader : this.resourceLoaderList) {
                template = loader.getLayout(path);
                if (template == null) continue;
                this.updateTemplate(template);
                return template;
            }
        }
        if (throwException) {
            throw this.wrapperException("\u627e\u4e0d\u5230\u6a21\u677f\uff1a" + path);
        }
        return null;
    }

    private Template getMacroLibrary(String path) throws TemplateException {
        Template template = null;
        if (!this.checkModified && (template = this.findTemplateCache(path)) != null) {
            this.updateTemplate(template);
            return template;
        }
        for (ResourceLoader loader : this.resourceLoaderList) {
            template = loader.getMacroLibrary(path);
            if (template == null) continue;
            this.updateTemplate(template);
            return template;
        }
        throw this.wrapperException("\u627e\u4e0d\u5230\u6a21\u677f\uff1a" + path);
    }

    public TemplateEngineDefault put(String key, Object value) {
        this.templateEngineContext.put(key, value);
        return this;
    }

    @Override
    public void renderMacro(String macroName, Template Template2, TemplateContext context, OutputStream outputStream) throws TemplateException {
        this.findMacro(macroName, Template2, context).render(Template2, context, context, outputStream);
    }

    @Override
    public void renderMacro(Macro macro, Template Template2, TemplateContext context, OutputStream outputStream) throws TemplateException {
        macro.render(Template2, context, context, outputStream);
    }

    @Override
    public void renderTemplate(String path, TemplateContext context, OutputStream outputStream) throws TemplateException {
        block7: {
            try {
                Template template = this.findTemplate(context, path);
                if (template != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    template.render(context, byteArrayOutputStream);
                    Integer renderLayer = (Integer)context.get("$renderLayer", 0);
                    List<Template> layoutPaths = this.getLayoutList(context, renderLayer, template.getPath());
                    if (layoutPaths.size() > 0) {
                        context.put("pageContent", byteArrayOutputStream);
                        ByteArrayOutputStream layoutWriter = null;
                        TemplateContext layoutContext = context;
                        for (int i = layoutPaths.size() - 1; i >= 0; --i) {
                            TemplateContextDefault tempContext = new TemplateContextDefault();
                            tempContext.setParent(layoutContext);
                            layoutContext = tempContext;
                            layoutWriter = new ByteArrayOutputStream();
                            layoutPaths.get(i).render(layoutContext, layoutWriter);
                            if (i <= 0) continue;
                            layoutContext.put("pageContent", layoutWriter);
                        }
                        outputStream.write(layoutWriter.toByteArray());
                    } else {
                        outputStream.write(byteArrayOutputStream.toByteArray());
                    }
                    break block7;
                }
                throw this.wrapperException("\u627e\u4e0d\u5230\u6a21\u677f\uff1a" + path);
            }
            catch (IOException e) {
                throw new TemplateException(e);
            }
            catch (TemplateException e) {
                TemplateException te = this.processTemplateException(e);
                throw te;
            }
        }
    }

    @Override
    public void renderTemplateWithOutLayout(String path, TemplateContext context, OutputStream outputStream) throws TemplateException {
        Template template = this.findTemplate(context, path);
        if (template == null) {
            throw this.wrapperException("\u627e\u4e0d\u5230\u6a21\u677f\uff1a" + path);
        }
        this.renderTemplate(template, context, outputStream);
    }

    private List<Template> getLayoutList(TemplateContext context, Integer renderLayer, String templatePath) throws TemplateException {
        int i;
        List<Template> layoutPathList = null;
        String cacheKey = templatePath + "|" + renderLayer.toString();
        if (!this.checkModified && (layoutPathList = this.layoutPathListCache.get(cacheKey)) != null) {
            return layoutPathList;
        }
        if (layoutPathList == null) {
            layoutPathList = new ArrayList<Template>();
        }
        String[] paths = templatePath.split("/");
        String[] dirs = new String[paths.length - 1];
        String pageName = paths[paths.length - 1];
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = i == 0 ? (templatePath.startsWith("/") ? "/" : "") : dirs[i - 1] + paths[i] + "/";
        }
        for (i = 0; i < dirs.length; ++i) {
            if (i == dirs.length - 1) {
                this.findLayoutTemplateList(dirs[i], paths[i + 1], dirs[i] + pageName, context, false, layoutPathList);
                continue;
            }
            this.findLayoutTemplateList(dirs[i], paths[i + 1], dirs[i] + pageName, context, true, layoutPathList);
        }
        if (renderLayer > 0 && renderLayer < layoutPathList.size()) {
            while (renderLayer < layoutPathList.size()) {
                layoutPathList.remove(0);
            }
        }
        if (!this.checkModified) {
            this.layoutPathListCache.put(cacheKey, layoutPathList);
        }
        return layoutPathList;
    }

    private void findLayoutTemplateList(String dirPath, String dirName, String pagePath, TemplateContext context, boolean queryTag, List<Template> layoutPathList) throws TemplateException {
        Template layout = null;
        layout = this.findLayoutTemplate(context, pagePath);
        if (layout != null) {
            layoutPathList.add(layout);
            return;
        }
        if (queryTag && (layout = this.findLayoutTemplate(context, dirPath, dirName)) != null) {
            layoutPathList.add(layout);
            return;
        }
        layout = this.findLayoutTemplate(context, dirPath, "default");
        if (layout != null) {
            layoutPathList.add(layout);
            return;
        }
    }

    private Template findLayoutTemplate(TemplateContext context, String pagePath) throws TemplateException {
        Template layout = null;
        for (ResourceLoader loader : this.resourceLoaderList) {
            String layoutPath = loader.getLayoutPath(pagePath);
            if (layoutPath == null || (layout = this.findLayout(context, layoutPath)) == null) continue;
            return layout;
        }
        return null;
    }

    private Template findLayoutTemplate(TemplateContext context, String path, String layoutName) throws TemplateException {
        Template layout = null;
        for (ResourceLoader loader : this.resourceLoaderList) {
            String layoutPath = path + layoutName + loader.getLayoutExtName();
            layout = this.findLayout(context, layoutPath);
            if (layout == null) continue;
            return layout;
        }
        return null;
    }

    @Override
    public void renderTemplate(String path) throws TemplateException {
        this.renderTemplate(path, (TemplateContext)new TemplateContextDefault(), (OutputStream)System.out);
    }

    @Override
    public void renderTemplate(Template Template2) throws TemplateException {
        this.renderTemplate(Template2, (TemplateContext)new TemplateContextDefault(), (OutputStream)System.out);
    }

    @Override
    public void renderTemplate(Template template, TemplateContext context, OutputStream outputStream) throws TemplateException {
        try {
            template.render(context, outputStream);
        }
        catch (TemplateException e) {
            TemplateException te = this.processTemplateException(e);
            throw te;
        }
    }

    @Override
    public Macro findMacro(Object macroNameObject, Template template, TemplateContext context) throws TemplateException {
        String macroName = macroNameObject.toString();
        Object obj = context.getItemMap().get(macroName);
        if (obj instanceof Macro) {
            return (Macro)obj;
        }
        Macro macro = template.getMacroMap().get(macroName);
        if (macro != null) {
            return macro;
        }
        for (int i = template.getImportPathList().size() - 1; i >= 0; --i) {
            Template macroLibrary = this.getMacroLibrary(template.getImportPathList().get(i));
            if (macroLibrary == null || (macro = macroLibrary.getMacroMap().get(macroName)) == null) continue;
            if (macro.getMacroPath() == null) {
                macro.setMacroPath(macroLibrary.getPath());
            }
            return macro;
        }
        macro = this.findMacroCache(macroName);
        if (macro != null) {
            return macro;
        }
        throw this.wrapperException("\u627e\u4e0d\u5230\u5b8f\uff1a" + macroName);
    }

    @Override
    public Object executeFunction(Template Template2, TemplateContext context, String functionName, Object ... parameters) throws TemplateException {
        TemplateFunction function = this.functionMap.get(functionName);
        if (function != null) {
            return function.execute(Template2, context, parameters);
        }
        throw this.wrapperException("\u627e\u4e0d\u5230\u51fd\u6570\uff1a" + functionName);
    }

    @Override
    public List<ResourceLoader> getResourceLoaderList() {
        return this.resourceLoaderList;
    }

    @Override
    public void setResourceLoaderList(List<ResourceLoader> resourceLoaderList) {
        this.resourceLoaderList = resourceLoaderList;
    }

    @Override
    public String getResourceContent(String path, String encode) throws TemplateException {
        for (ResourceLoader resourceLoader : this.resourceLoaderList) {
            String content = resourceLoader.getResourceContent(path, encode);
            if (content == null) continue;
            return content;
        }
        throw this.wrapperException("\u627e\u4e0d\u5230\u8d44\u6e90\uff1a" + path);
    }

    @Override
    public String getResourceContent(String path) throws TemplateException {
        return this.getResourceContent(path, this.getEncode());
    }

    @Override
    public void registerStaticClassOperator(StaticClassOperator operator) throws TemplateException {
        staticClassOperatorMap.put(operator.getName(), operator);
    }

    @Override
    public StaticClassOperator getStaticClassOperator(String name) throws TemplateException {
        return staticClassOperatorMap.get(name);
    }

    private TemplateException processTemplateException(TemplateException e) {
        List list = ExceptionUtil.getCauses((Throwable)e, (boolean)true);
        if (list != null) {
            TemplateException te = null;
            for (Throwable throwable : list) {
                if (!(throwable instanceof TemplateException)) continue;
                te = (TemplateException)throwable;
                te.recombine();
                return te;
            }
        }
        return e;
    }

    @Override
    public Template findTemplateCache(String path) {
        Map<String, Template> map = this.templateCache.get(path);
        if (map != null && map.size() > 0) {
            return (Template)Collections.min(map.values(), this.comparator);
        }
        return null;
    }

    @Override
    public Template findTemplateCache(String path, String absolutePath) {
        Map<String, Template> map = this.templateCache.get(path);
        if (map != null) {
            return map.get(absolutePath);
        }
        return null;
    }

    @Override
    public void addTemplateCache(String path, Template template) {
        Map<String, Template> map = this.templateCache.get(path);
        if (map == null) {
            map = new HashMap<String, Template>();
            this.templateCache.put(path, map);
        }
        map.put(template.getAbsolutePath(), template);
    }

    @Override
    public void removeTemplateCache(String path, String absolutePath) {
        Map<String, Template> map = this.templateCache.get(path);
        if (map != null) {
            map.remove(absolutePath);
            if (map.isEmpty()) {
                this.templateCache.remove(path);
            }
        }
    }

    @Override
    public Macro findMacroCache(String macroName) {
        Map<String, Macro> map = this.macroCache.get(macroName);
        if (map != null && map.size() > 0) {
            return (Macro)Collections.min(map.values(), this.comparator);
        }
        return null;
    }

    @Override
    public void addMacroCache(String macroName, Macro macro) {
        Map<String, Macro> map = this.macroCache.get(macroName);
        if (map == null) {
            map = new HashMap<String, Macro>();
            this.macroCache.put(macroName, map);
        }
        map.put(macro.getAbsolutePath(), macro);
    }

    @Override
    public void removeMacroCache(String macroName, String absolutePath) {
        Map<String, Macro> map = this.macroCache.get(macroName);
        if (map != null) {
            map.remove(absolutePath);
            if (map.isEmpty()) {
                this.macroCache.remove(macroName);
            }
        }
    }

    public Map<String, Map<String, Macro>> getMacroCache() {
        return this.macroCache;
    }

    static {
        interpreter.addTerminalNodeProcessor(new IntegerOctNodeProcessor());
        interpreter.addTerminalNodeProcessor(new EscapeTextNodeProcessor());
        interpreter.addTerminalNodeProcessor(new FalseNodeProcessor());
        interpreter.addTerminalNodeProcessor(new IntegerNodeProcessor());
        interpreter.addTerminalNodeProcessor(new NullNodeProcessor());
        interpreter.addTerminalNodeProcessor(new StringDoubleNodeProcessor());
        interpreter.addTerminalNodeProcessor(new StringSingleNodeProcessor());
        interpreter.addTerminalNodeProcessor(new TextCdataNodeProcessor());
        interpreter.addTerminalNodeProcessor(new TextPlainNodeProcessor());
        interpreter.addTerminalNodeProcessor(new TrueNodeProcessor());
        interpreter.addTerminalNodeProcessor(new FloatProcessor());
        interpreter.addTerminalNodeProcessor(new IntegerHexNodeProcessor());
        interpreter.addContextProcessor(new PageContentProcessor());
        interpreter.addContextProcessor(new MapProcessor());
        interpreter.addContextProcessor(new ExpressionGroupProcessor());
        interpreter.addContextProcessor(new ValueProcessor());
        interpreter.addContextProcessor(new ForProcessor());
        interpreter.addContextProcessor(new SetProcessor());
        interpreter.addContextProcessor(new IfProcessor());
        interpreter.addContextProcessor(new ElseIfProcessor());
        interpreter.addContextProcessor(new RangeProcessor());
        interpreter.addContextProcessor(new ArrayProcessor());
        interpreter.addContextProcessor(new MathBinaryProcessor());
        interpreter.addContextProcessor(new MathCompareProcessor());
        interpreter.addContextProcessor(new MathSingleRightProcessor());
        interpreter.addContextProcessor(new MathSingleLeftProcessor());
        interpreter.addContextProcessor(new BlankProcessor());
        interpreter.addContextProcessor(new TabProcessor());
        interpreter.addContextProcessor(new EolProcessor());
        interpreter.addContextProcessor(new CommentProcessor());
        interpreter.addContextProcessor(new MathIdentifierProcessor());
        interpreter.addContextProcessor(new ForBreakProcessor());
        interpreter.addContextProcessor(new ForContinueProcessor());
        interpreter.addContextProcessor(new MapListProcessor());
        interpreter.addContextProcessor(new MathUnaryProcessor());
        interpreter.addContextProcessor(new MathConditionProcessor());
        interpreter.addContextProcessor(new MathConditionSimpleProcessor());
        interpreter.addContextProcessor(new MathCompareConditionProcessor());
        interpreter.addContextProcessor(new MathCompareRalationProcessor());
        interpreter.addContextProcessor(new MathBinaryShiftProcessor());
        interpreter.addContextProcessor(new MathBitwiseProcessor());
        interpreter.addContextProcessor(new ArrayGetProcessor());
        interpreter.addContextProcessor(new ImportIgnoreProcessor());
        interpreter.addContextProcessor(new MacroDefineIgnoreProcessor());
        interpreter.addContextProcessor(new CallProcessor());
        interpreter.addContextProcessor(new CallWithBodyProcessor());
        interpreter.addContextProcessor(new CallMacroProcessor());
        interpreter.addContextProcessor(new CallMacroWithBodyProcessor());
        interpreter.addContextProcessor(new LayoutDefineProcessor());
        interpreter.addContextProcessor(new LayoutImplementProcessor());
        interpreter.addContextProcessor(new DentProcessor());
        interpreter.addContextProcessor(new IndentProcessor());
        interpreter.addContextProcessor(new TextProcessor());
        interpreter.addContextProcessor(new BodyContentProcessor());
        interpreter.addContextProcessor(new FieldProcessor());
        interpreter.addContextProcessor(new StopProcessor());
        interpreter.addContextProcessor(new ReturnProcessor());
        interpreter.addContextProcessor(new IncludeProcessor());
        interpreter.addContextProcessor(new MemberFunctionCallProcessor());
        interpreter.addContextProcessor(new FunctionCallProcessor());
        interpreter.addContextProcessor(new WhileProcessor());
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("Integer", Integer.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("Long", Long.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("Short", Short.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("Double", Double.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("Float", Float.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("Boolean", Boolean.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("String", String.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("Byte", Byte.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("Number", Number.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("Math", Math.class));
        TemplateEngineDefault.addDefaultStaticClassOperator(new DefaultStaticClassOperator("System", System.class));
    }

    static class UpdatableComparator
    implements Comparator<Updatable> {
        UpdatableComparator() {
        }

        @Override
        public int compare(Updatable o1, Updatable o2) {
            if (o1.getLastModifiedTime() > o2.getLastModifiedTime()) {
                return -1;
            }
            if (o1.getLastModifiedTime() < o2.getLastModifiedTime()) {
                return 1;
            }
            return 0;
        }
    }
}

