/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.TemplateRender;
import org.tinygroup.template.loader.StringResourceLoader;

public class TemplateRenderDefault
implements TemplateRender {
    private TemplateEngine templateEngine;

    @Override
    public TemplateEngine getTemplateEngine() {
        if (this.templateEngine == null) {
            return (TemplateEngine)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("templateEngine");
        }
        return this.templateEngine;
    }

    @Override
    public void setTemplateEngine(TemplateEngine engine) {
        this.templateEngine = engine;
    }

    @Override
    public void renderTemplate(String path, TemplateContext context, OutputStream outputStream) throws TemplateException {
        this.getTemplateEngine().renderTemplate(path, context, outputStream);
    }

    @Override
    public String renderTemplate(String path, TemplateContext context) throws TemplateException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.renderTemplate(path, context, outputStream);
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateException(e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new TemplateException(e);
            }
        }
    }

    @Override
    public void renderTemplateWithOutLayout(String path, TemplateContext context, OutputStream outputStream) throws TemplateException {
        this.getTemplateEngine().renderTemplateWithOutLayout(path, context, outputStream);
    }

    @Override
    public String renderTemplateWithOutLayout(String path, TemplateContext context) throws TemplateException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.renderTemplateWithOutLayout(path, context, outputStream);
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateException(e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new TemplateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTemplateContent(String content, TemplateContext context, OutputStream outputStream) throws TemplateException {
        StringResourceLoader stringResourceLoader = new StringResourceLoader();
        try {
            stringResourceLoader.setTemplateEngine(this.getTemplateEngine());
            Template template = stringResourceLoader.loadTemplate(content);
            template.render(context, outputStream);
        }
        finally {
            stringResourceLoader.setTemplateEngine(null);
        }
    }

    @Override
    public String renderTemplateContent(String content, TemplateContext context) throws TemplateException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.renderTemplateContent(content, context, outputStream);
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateException(e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new TemplateException(e);
            }
        }
    }
}

