/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.interpret;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.template.Macro;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.EvaluateExpression;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.interpret.MacroException;
import org.tinygroup.template.interpret.ReturnException;
import org.tinygroup.template.interpret.TemplateFromContext;
import org.tinygroup.template.interpret.TemplateInterpreter;
import org.tinygroup.template.parser.grammer.TinyTemplateParser;

public class MacroFromContext
implements Macro {
    private final String name;
    private final TemplateInterpreter interpreter;
    private final TinyTemplateParser.BlockContext blockContext;
    private final TemplateFromContext templateFromContext;
    private List<String> parameterNames = new ArrayList<String>();
    private List<EvaluateExpression> parameterDefaultValues = new ArrayList<EvaluateExpression>();
    private TemplateEngineDefault templateEngineDefault;
    private String macroPath;
    private long lastModifiedTime;
    private String absolutePath;

    public MacroFromContext(TemplateInterpreter interpreter, String name, TinyTemplateParser.BlockContext blockContext, TemplateFromContext templateFromContext) {
        this.name = name;
        this.blockContext = blockContext;
        this.interpreter = interpreter;
        this.templateFromContext = templateFromContext;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public void addParameter(String parameterName, EvaluateExpression defaultValue) {
        this.parameterNames.add(parameterName);
        this.parameterDefaultValues.add(defaultValue);
    }

    @Override
    public String getParameterName(int index) {
        return this.parameterNames.get(index);
    }

    @Override
    public List<EvaluateExpression> getParameterDefaultValues() {
        return this.parameterDefaultValues;
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        return this.templateEngineDefault;
    }

    @Override
    public void setTemplateEngine(TemplateEngine engine) {
        this.templateEngineDefault = (TemplateEngineDefault)engine;
    }

    @Override
    public void render(Template templateFromContext, TemplateContext pageContext, TemplateContext context, OutputStream outputStream) throws TemplateException {
        try {
            this.interpreter.interpretTree(this.templateEngineDefault, (TemplateFromContext)templateFromContext, (ParseTree)this.blockContext, pageContext, context, outputStream, this.templateFromContext.getPath());
        }
        catch (ReturnException returnException) {
        }
        catch (MacroException e) {
            throw e;
        }
        catch (TemplateException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    @Override
    public String getMacroPath() {
        return this.macroPath;
    }

    @Override
    public void setMacroPath(String macroPath) {
        this.macroPath = macroPath;
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public void setLastModifiedTime(long time) {
        this.lastModifiedTime = time;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public void setAbsolutePath(String path) {
        this.absolutePath = path;
    }
}

