/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.interpret.context;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.template.Macro;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.TemplateContextDefault;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.interpret.ContextProcessor;
import org.tinygroup.template.interpret.MacroException;
import org.tinygroup.template.interpret.TemplateFromContext;
import org.tinygroup.template.parser.grammer.TinyTemplateParser;

public abstract class AbstractCallMacroProcessor<T extends ParserRuleContext>
implements ContextProcessor<T> {
    public void callMacro(TemplateEngineDefault engine, TemplateFromContext templateFromContext, String name, TinyTemplateParser.Para_expression_listContext paraList, TemplateContext pageContext, TemplateContext context, OutputStream outputStream) throws Exception {
        this.callBlockMacro(engine, templateFromContext, name, null, paraList, pageContext, outputStream, context);
    }

    public void callBlockMacro(TemplateEngineDefault engine, TemplateFromContext templateFromContext, String name, TinyTemplateParser.BlockContext block, TinyTemplateParser.Para_expression_listContext paraList, TemplateContext pageContext, OutputStream outputStream, TemplateContext context) throws Exception {
        Macro macro = engine.findMacro(name, templateFromContext, context);
        try {
            Stack<TinyTemplateParser.BlockContext> stack;
            TemplateContextDefault newContext = new TemplateContextDefault();
            newContext.setParent(context);
            if (paraList != null) {
                int i = 0;
                ArrayList<Object> parameterList = new ArrayList<Object>();
                for (TinyTemplateParser.Para_expressionContext para : paraList.para_expression()) {
                    Object value;
                    if (para.getChildCount() == 3) {
                        value = TemplateEngineDefault.interpreter.interpretTree(engine, templateFromContext, (ParseTree)para.expression(), pageContext, context, outputStream, templateFromContext.getPath());
                        newContext.put(para.IDENTIFIER().getSymbol().getText(), value);
                        parameterList.add(value);
                    } else {
                        if (i >= macro.getParameterNames().size()) {
                            throw new TemplateException("\u53c2\u6570\u6570\u91cf\u8d85\u8fc7\u5b8f<" + macro.getName() + ">\u5141\u8bb8\u63a5\u53d7\u7684\u6570\u91cf", (ParserRuleContext)paraList, templateFromContext.getPath());
                        }
                        value = TemplateEngineDefault.interpreter.interpretTree(engine, templateFromContext, (ParseTree)para.expression(), pageContext, context, outputStream, templateFromContext.getPath());
                        newContext.put(macro.getParameterName(i), value);
                        parameterList.add(value);
                    }
                    ++i;
                }
                newContext.put(name + "ParameterList", parameterList);
            }
            if ((stack = (Stack<TinyTemplateParser.BlockContext>)context.get("$bodyContent")) == null) {
                stack = new Stack<TinyTemplateParser.BlockContext>();
                newContext.put("$bodyContent", stack);
            }
            stack.push(block);
            int stackSize = stack.size();
            macro.render(templateFromContext, pageContext, newContext, outputStream);
            if (stack.size() == stackSize) {
                stack.pop();
            }
        }
        catch (MacroException me) {
            throw new MacroException(macro, me);
        }
        catch (TemplateException te) {
            throw new MacroException(macro, te);
        }
        catch (Exception e) {
            throw new MacroException(macro, e);
        }
    }
}

