/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.interpret.context;

import java.io.OutputStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.interpret.CompareConditionException;
import org.tinygroup.template.interpret.ContextProcessor;
import org.tinygroup.template.interpret.TemplateFromContext;
import org.tinygroup.template.interpret.TemplateInterpreter;
import org.tinygroup.template.parser.grammer.TinyTemplateParser;
import org.tinygroup.template.rumtime.OperationUtil;
import org.tinygroup.template.rumtime.TemplateUtil;

public class MathCompareConditionProcessor
implements ContextProcessor<TinyTemplateParser.Expr_compare_conditionContext> {
    @Override
    public Class<TinyTemplateParser.Expr_compare_conditionContext> getType() {
        return TinyTemplateParser.Expr_compare_conditionContext.class;
    }

    @Override
    public Object process(TemplateInterpreter interpreter, TemplateFromContext templateFromContext, TinyTemplateParser.Expr_compare_conditionContext parseTree, TemplateContext pageContext, TemplateContext context, TemplateEngineDefault engine, OutputStream outputStream, String fileName) throws Exception {
        try {
            boolean a = TemplateUtil.getBooleanValue(interpreter.interpretTree(engine, templateFromContext, (ParseTree)parseTree.expression().get(0), pageContext, context, outputStream, fileName));
            String op = parseTree.getChild(1).getText();
            if (this.checkShortAnd(a, op)) {
                throw new CompareConditionException(a);
            }
            if (this.checkShortOr(a, op)) {
                throw new CompareConditionException(a);
            }
            boolean b = TemplateUtil.getBooleanValue(interpreter.interpretTree(engine, templateFromContext, (ParseTree)parseTree.expression().get(1), pageContext, context, outputStream, fileName));
            return OperationUtil.executeOperation(op, a, b);
        }
        catch (CompareConditionException e) {
            if (this.getType() != parseTree.getParent().getClass()) {
                return e.getTag();
            }
            throw e;
        }
    }

    private boolean checkShortAnd(Object obj, String op) {
        if (obj != null && obj instanceof Boolean && "&&".equals(op)) {
            return (Boolean)obj == false;
        }
        return false;
    }

    private boolean checkShortOr(Object obj, String op) {
        if (obj != null && obj instanceof Boolean && "||".equals(op)) {
            return (Boolean)obj;
        }
        return false;
    }
}

