/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.interpret.terminal;

import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.impl.TemplateRenderDefault;
import org.tinygroup.template.interpret.TemplateFromContext;
import org.tinygroup.template.interpret.TerminalNodeProcessor;

public abstract class AbstractStringNodeProcessor
implements TerminalNodeProcessor<TerminalNode> {
    private static final String rule = "[$][{][^}]*[}]";
    private static final Pattern pattern = Pattern.compile("[$][{][^}]*[}]");

    public boolean processChildren() {
        return false;
    }

    @Override
    public Object process(TerminalNode terminalNode, TemplateContext context, OutputStream outputStream, TemplateFromContext templateFromContext) throws Exception {
        String text = (String)templateFromContext.getObject((ParseTree)terminalNode);
        if (text == null) {
            text = this.getText(terminalNode);
            if (pattern.matcher(text).find()) {
                Matcher matcher = pattern.matcher(text);
                StringBuilder sb = new StringBuilder();
                int pos = 0;
                TemplateRenderDefault render = new TemplateRenderDefault();
                render.setTemplateEngine(templateFromContext.getTemplateEngine());
                while (matcher.find()) {
                    String group = matcher.group();
                    sb.append(text.substring(pos, matcher.start()));
                    sb.append(render.renderTemplateContent(group, context));
                    pos = matcher.end();
                }
                sb.append(text.substring(pos));
                return sb.toString();
            }
            templateFromContext.putObject((ParseTree)terminalNode, text);
        }
        return text;
    }

    protected abstract String getText(TerminalNode var1);
}

