/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.loader;

import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateException;

public abstract class AbstractResourceLoader<T>
implements ResourceLoader<T> {
    private ClassLoader classLoader;
    private TemplateEngine templateEngine;
    private String templateExtName;
    private String layoutExtName;
    private String macroLibraryExtName;

    public AbstractResourceLoader(String templateExtName, String layoutExtName, String macroLibraryExtName) {
        if (templateExtName != null) {
            this.templateExtName = "." + templateExtName;
        }
        if (layoutExtName != null) {
            this.layoutExtName = "." + layoutExtName;
        }
        if (macroLibraryExtName != null) {
            this.macroLibraryExtName = "." + macroLibraryExtName;
        }
        this.setClassLoader(this.getClass().getClassLoader());
    }

    public boolean isTemplate(String path) {
        return this.templateExtName == null ? false : path.endsWith(this.templateExtName);
    }

    public boolean isLayout(String path) {
        return this.layoutExtName == null ? false : path.endsWith(this.layoutExtName);
    }

    public boolean isMacroLibrary(String path) {
        return this.macroLibraryExtName == null ? false : path.endsWith(this.macroLibraryExtName);
    }

    public boolean isLoadResource(String path) {
        return this.isTemplate(path) || this.isLayout(path) || this.isMacroLibrary(path);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getLayoutPath(String templatePath) {
        if (this.templateExtName != null && templatePath.endsWith(this.templateExtName)) {
            return templatePath.substring(0, templatePath.length() - this.templateExtName.length()) + this.layoutExtName;
        }
        return null;
    }

    @Override
    public String getTemplateExtName() {
        return this.templateExtName;
    }

    public void setTemplateExtName(String templateExtName) {
        this.templateExtName = templateExtName;
    }

    @Override
    public String getLayoutExtName() {
        return this.layoutExtName;
    }

    public void setLayoutExtName(String layoutExtName) {
        this.layoutExtName = layoutExtName;
    }

    public String getMacroLibraryExtName() {
        return this.macroLibraryExtName;
    }

    public void setMacroLibraryExtName(String macroLibraryExtName) {
        this.macroLibraryExtName = macroLibraryExtName;
    }

    @Override
    public Template getTemplate(String path) throws TemplateException {
        return this.getTemplateItem(path, this.templateExtName);
    }

    private Template getTemplateItem(String path, String templateExtName) throws TemplateException {
        if (templateExtName != null && !path.endsWith(templateExtName)) {
            return null;
        }
        Template template = this.getTemplateEngine().findTemplateCache(path);
        if ((template == null || this.isModified(path)) && (template = this.loadTemplateItem(path)) != null) {
            this.resetModified(path);
        }
        return template;
    }

    @Override
    public Template getLayout(String path) throws TemplateException {
        return this.getTemplateItem(path, this.layoutExtName);
    }

    @Override
    public Template getMacroLibrary(String path) throws TemplateException {
        return this.getTemplateItem(path, this.macroLibraryExtName);
    }

    protected abstract Template loadTemplateItem(String var1) throws TemplateException;

    @Override
    public ResourceLoader addTemplate(Template template) throws TemplateException {
        return this.addTemplateItem(template);
    }

    private ResourceLoader addTemplateItem(Template template) throws TemplateException {
        if (!this.getTemplateEngine().isCheckModified()) {
            this.getTemplateEngine().addTemplateCache(template.getPath(), template);
        }
        template.setTemplateEngine(this.templateEngine);
        template.getTemplateContext().setParent(this.templateEngine.getTemplateContext());
        return this;
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @Override
    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }
}

