/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.loader;

import java.io.InputStream;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.loader.AbstractResourceLoader;
import org.tinygroup.template.loader.FileResourceManager;
import org.tinygroup.template.loader.TemplateLoadUtil;
import org.tinygroup.vfs.FileObject;

public class FileObjectResourceLoader
extends AbstractResourceLoader<FileObject> {
    private FileResourceManager fileResourceManager;

    public FileObjectResourceLoader() {
        super(null, null, null);
    }

    public FileObjectResourceLoader(String templateExtName, String layoutExtName, String macroLibraryExtName) {
        super(templateExtName, layoutExtName, macroLibraryExtName);
    }

    public FileResourceManager getFileResourceManager() {
        return this.fileResourceManager;
    }

    public void setFileResourceManager(FileResourceManager fileResourceManager) {
        this.fileResourceManager = fileResourceManager;
    }

    @Override
    public Template createTemplate(FileObject fileObject) throws TemplateException {
        if (fileObject != null) {
            return this.loadTemplate(fileObject);
        }
        return null;
    }

    @Override
    protected Template loadTemplateItem(String path) throws TemplateException {
        boolean tag = this.isLayout(path);
        return this.createTemplate(this.fileResourceManager.getFileObject(path, tag));
    }

    @Override
    public boolean isModified(String path) {
        boolean tag = this.isLayout(path);
        return this.fileResourceManager.isModified(path, tag);
    }

    @Override
    public void resetModified(String path) {
        boolean tag = this.isLayout(path);
        this.fileResourceManager.resetModified(path, tag);
    }

    @Override
    public String getResourceContent(String path, String encode) throws TemplateException {
        FileObject fileObject = null;
        if (this.isLoadResource(path)) {
            boolean tag = this.isLayout(path);
            fileObject = this.fileResourceManager.getFileObject(path, tag);
        } else {
            fileObject = this.fileResourceManager.getOtherFileObject(path);
        }
        if (fileObject != null) {
            InputStream inputStream = fileObject.getInputStream();
            try {
                String string = IOUtils.readFromInputStream((InputStream)inputStream, (String)encode);
                return string;
            }
            catch (Exception e) {
                throw new TemplateException(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        throw new TemplateException(e);
                    }
                }
            }
        }
        return null;
    }

    private Template loadTemplate(FileObject fileObject) throws TemplateException {
        try {
            Template templateFromContext = TemplateLoadUtil.loadComponent((TemplateEngineDefault)this.getTemplateEngine(), fileObject.getPath(), fileObject.getAbsolutePath(), fileObject.getLastModifiedTime(), this.getResourceContent(fileObject.getPath(), this.getTemplateEngine().getEncode()));
            this.addTemplate(templateFromContext);
            return templateFromContext;
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }
}

