/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.template.Macro;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.loader.TemplateLoadUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.FileObjectFilter;
import org.tinygroup.vfs.FileObjectProcessor;
import org.tinygroup.vfs.VFS;

public class FileResourceManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FileResourceManager.class);
    private Map<String, Map<String, FileObject>> resources = new ConcurrentHashMap<String, Map<String, FileObject>>();
    private FileResolver fileResolver;
    private List<FileObject> scanFileList = new ArrayList<FileObject>();
    private Comparator<FileObject> comparator = new FileObjectComparator();
    private boolean textOrderByTime = false;

    public boolean isTextOrderByTime() {
        return this.textOrderByTime;
    }

    public void setTextOrderByTime(boolean textOrderByTime) {
        this.textOrderByTime = textOrderByTime;
    }

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void addScanFile(FileObject file) {
        if (!this.scanFileList.contains(file)) {
            this.scanFileList.add(file);
        }
    }

    public void addResources(TemplateEngine engine, FileObject root, String templateExtName, String layoutExtName, String componentExtName) {
        this.addResources(engine, root, templateExtName, layoutExtName, componentExtName, true);
    }

    public void addResources(final TemplateEngine engine, FileObject root, final String templateExtName, final String layoutExtName, final String componentExtName, final boolean logTag) {
        this.addScanFile(root);
        root.foreach(new FileObjectFilter(){

            public boolean accept(FileObject fileObject) {
                String name = fileObject.getFileName();
                return templateExtName != null && name.endsWith(templateExtName) || layoutExtName != null && name.endsWith(layoutExtName) || componentExtName != null && name.endsWith(componentExtName);
            }
        }, new FileObjectProcessor(){

            public void process(FileObject fileObject) {
                block8: {
                    if (logTag) {
                        LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u5f00\u59cb\u52a0\u8f7d", new Object[]{fileObject.getAbsolutePath()});
                    }
                    try {
                        FileResourceManager.this.addResource(fileObject.getPath(), fileObject);
                        Template template = engine.findTemplateCache(fileObject.getPath(), fileObject.getAbsolutePath());
                        if (template != null) {
                            if (componentExtName != null && fileObject.getFileName().endsWith(componentExtName)) {
                                for (Macro macro : template.getMacroMap().values()) {
                                    engine.removeMacroCache(macro.getName(), macro.getAbsolutePath());
                                }
                            }
                            engine.removeTemplateCache(fileObject.getPath(), fileObject.getAbsolutePath());
                        }
                        template = TemplateLoadUtil.loadComponent((TemplateEngineDefault)engine, fileObject);
                        template.setTemplateEngine(engine);
                        engine.addTemplateCache(template.getPath(), template);
                        if (componentExtName != null && fileObject.getFileName().endsWith(componentExtName)) {
                            engine.registerMacroLibrary(template);
                        }
                    }
                    catch (Exception e) {
                        if (!logTag) break block8;
                        LOGGER.errorMessage("\u52a0\u8f7d\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u51fa\u9519,\u6ce8\u518c\u4e3b\u952e[{1}]", (Throwable)e, new Object[]{fileObject.getAbsolutePath(), fileObject.getPath()});
                    }
                }
                if (logTag) {
                    LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u52a0\u8f7d\u5b8c\u6bd5,\u6ce8\u518c\u4e3b\u952e[{1}]", new Object[]{fileObject.getAbsolutePath(), fileObject.getPath()});
                }
            }
        });
    }

    public void addResources(TemplateEngine engine, String resource, String templateExtName, String layoutExtName, String componentExtName) {
        FileObject root = VFS.resolveFile((String)resource);
        this.addResources(engine, root, templateExtName, layoutExtName, componentExtName);
    }

    public boolean addResource(String path, FileObject file) {
        Map<String, FileObject> fileMap = this.resources.get(path);
        if (fileMap == null) {
            fileMap = new ConcurrentHashMap<String, FileObject>();
            this.resources.put(path, fileMap);
        }
        fileMap.put(file.getAbsolutePath(), file);
        return true;
    }

    public void removeScanFile(FileObject file) {
        this.scanFileList.remove(file);
    }

    public void removeResources(final TemplateEngine engine, FileObject root, final String templateExtName, final String layoutExtName, final String componentExtName) {
        this.removeScanFile(root);
        root.foreach(new FileObjectFilter(){

            public boolean accept(FileObject fileObject) {
                String name = fileObject.getFileName();
                return templateExtName != null && name.endsWith(templateExtName) || layoutExtName != null && name.endsWith(layoutExtName) || componentExtName != null && name.endsWith(componentExtName);
            }
        }, new FileObjectProcessor(){

            public void process(FileObject fileObject) {
                LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u5f00\u59cb\u79fb\u9664", new Object[]{fileObject.getAbsolutePath()});
                try {
                    FileResourceManager.this.removeResource(fileObject);
                    Template template = engine.findTemplateCache(fileObject.getPath(), fileObject.getAbsolutePath());
                    if (template != null) {
                        engine.removeTemplateCache(template.getPath(), template.getAbsolutePath());
                        if (componentExtName != null && fileObject.getFileName().endsWith(componentExtName)) {
                            for (Macro macro : template.getMacroMap().values()) {
                                engine.removeMacroCache(macro.getName(), macro.getAbsolutePath());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u79fb\u9664\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u51fa\u9519,\u5378\u8f7d\u4e3b\u952e[{1}]", (Throwable)e, new Object[]{fileObject.getAbsolutePath(), fileObject.getPath()});
                }
                LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u8d44\u6e90\u6587\u4ef6[{0}]\u79fb\u9664\u5b8c\u6bd5,\u5378\u8f7d\u4e3b\u952e[{1}]", new Object[]{fileObject.getAbsolutePath(), fileObject.getPath()});
            }
        });
    }

    public void removeResources(TemplateEngine engine, String resource, String templateExtName, String layoutExtName, String componentExtName) {
        FileObject root = VFS.resolveFile((String)resource);
        this.removeResources(engine, root, templateExtName, layoutExtName, componentExtName);
    }

    public void removeResource(FileObject file) {
        String path = file.getPath();
        Map<String, FileObject> fileMap = this.resources.get(path);
        if (fileMap != null) {
            fileMap.remove(file.getAbsolutePath());
            if (fileMap.isEmpty()) {
                this.resources.remove(path);
            }
        }
    }

    public FileObject getFileObject(String path, boolean tag) {
        if (this.resources.containsKey(path = this.filterPath(path))) {
            return this.findFileObject(path);
        }
        return null;
    }

    private FileObject findFileObject(String path) {
        Map<String, FileObject> fileMap = this.resources.get(path);
        if (fileMap != null && !fileMap.isEmpty()) {
            return Collections.min(fileMap.values(), this.comparator);
        }
        return null;
    }

    public FileObject getFileObject(String path) {
        return this.getFileObject(path, false);
    }

    public FileObject getOtherFileObject(String path) {
        if (this.textOrderByTime) {
            HashSet<FileObject> sets = new HashSet<FileObject>();
            if (this.fileResolver != null) {
                for (String rootPath : this.fileResolver.getScanningPaths()) {
                    FileObject root = VFS.resolveFile((String)rootPath);
                    FileObject file = root.getFileObject(path);
                    if (file == null) continue;
                    sets.add(file);
                }
            }
            for (FileObject root : this.scanFileList) {
                FileObject file = root.getFileObject(path);
                if (file == null) continue;
                sets.add(file);
            }
            return Collections.min(sets, this.comparator);
        }
        if (this.fileResolver != null) {
            for (String rootPath : this.fileResolver.getScanningPaths()) {
                FileObject root = VFS.resolveFile((String)rootPath);
                FileObject file = root.getFileObject(path);
                if (file == null) continue;
                return file;
            }
        }
        for (FileObject root : this.scanFileList) {
            FileObject file = root.getFileObject(path);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private String mergePath(String[] dirs, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = n; i < dirs.length; ++i) {
            sb.append("/").append(dirs[i]);
        }
        return sb.toString();
    }

    private String filterPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private String[] splitPath(String path) {
        path = path.startsWith("/") ? path.substring(1) : path;
        return path.split("/");
    }

    public boolean isModified(String path) {
        return this.isModified(path, false);
    }

    public boolean isModified(String path, boolean tag) {
        FileObject fileObject = this.getFileObject(path, tag);
        if (fileObject == null) {
            return true;
        }
        return fileObject.isModified();
    }

    public void resetModified(String path) {
        this.resetModified(path, false);
    }

    public void resetModified(String path, boolean tag) {
        FileObject fileObject = this.getFileObject(path, tag);
        if (fileObject != null) {
            fileObject.resetModified();
        }
    }

    static class FileObjectComparator
    implements Comparator<FileObject> {
        FileObjectComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            if (o1.getLastModifiedTime() > o2.getLastModifiedTime()) {
                return -1;
            }
            if (o1.getLastModifiedTime() < o2.getLastModifiedTime()) {
                return 1;
            }
            return 0;
        }
    }
}

