/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.loader;

import java.io.InputStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.template.Template;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.interpret.TemplateFromContext;
import org.tinygroup.template.interpret.TemplateInterpreter;
import org.tinygroup.template.interpret.context.ImportProcessor;
import org.tinygroup.template.interpret.context.MacroDefineProcessor;
import org.tinygroup.template.parser.grammer.TinyTemplateParser;
import org.tinygroup.vfs.FileObject;

public final class TemplateLoadUtil {
    static TemplateInterpreter interpreter = new TemplateInterpreter();

    public static Template loadComponent(TemplateEngineDefault engine, String path, String absolutePath, long lastModifiedTime, String content) throws Exception {
        TinyTemplateParser.TemplateContext tree = interpreter.parserTemplateTree(path, content, engine.isThrowLexerError());
        TemplateFromContext template = new TemplateFromContext(path, tree);
        template.setAbsolutePath(absolutePath);
        template.setLastModifiedTime(lastModifiedTime);
        interpreter.interpretTree(engine, template, (ParseTree)tree, null, null, null, path);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Template loadComponent(TemplateEngineDefault engine, FileObject fileObject) throws Exception {
        InputStream inputStream = fileObject.getInputStream();
        try {
            String content = IOUtils.readFromInputStream((InputStream)inputStream, (String)engine.getEncode());
            Template template = TemplateLoadUtil.loadComponent(engine, fileObject.getPath(), fileObject.getAbsolutePath(), fileObject.getLastModifiedTime(), content);
            return template;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    static {
        interpreter.addContextProcessor(new MacroDefineProcessor());
        interpreter.addContextProcessor(new ImportProcessor());
    }
}

