/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.rumtime;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.rumtime.Converter;
import org.tinygroup.template.rumtime.Operator;
import org.tinygroup.template.rumtime.OperatorWithContext;
import org.tinygroup.template.rumtime.convert.ByteBigDecimal;
import org.tinygroup.template.rumtime.convert.ByteCharacter;
import org.tinygroup.template.rumtime.convert.ByteDouble;
import org.tinygroup.template.rumtime.convert.ByteFloat;
import org.tinygroup.template.rumtime.convert.ByteInteger;
import org.tinygroup.template.rumtime.convert.CharacterBigDecimal;
import org.tinygroup.template.rumtime.convert.CharacterDouble;
import org.tinygroup.template.rumtime.convert.CharacterFloat;
import org.tinygroup.template.rumtime.convert.CharacterInteger;
import org.tinygroup.template.rumtime.convert.DoubleBigDecimal;
import org.tinygroup.template.rumtime.convert.FloatBigDecimal;
import org.tinygroup.template.rumtime.convert.FloatDouble;
import org.tinygroup.template.rumtime.convert.IntegerBigDecimal;
import org.tinygroup.template.rumtime.convert.IntegerDouble;
import org.tinygroup.template.rumtime.convert.IntegerFloat;
import org.tinygroup.template.rumtime.convert.IntegerLong;
import org.tinygroup.template.rumtime.convert.LongBigDecimal;
import org.tinygroup.template.rumtime.convert.LongDouble;
import org.tinygroup.template.rumtime.convert.LongFloat;
import org.tinygroup.template.rumtime.operator.AdOperator;
import org.tinygroup.template.rumtime.operator.AddOperator;
import org.tinygroup.template.rumtime.operator.AndLogicOperator;
import org.tinygroup.template.rumtime.operator.BigEqualsOperator;
import org.tinygroup.template.rumtime.operator.BigOperator;
import org.tinygroup.template.rumtime.operator.ComplementOperator;
import org.tinygroup.template.rumtime.operator.DevideOperator;
import org.tinygroup.template.rumtime.operator.EqualsOperator;
import org.tinygroup.template.rumtime.operator.LeftAddOperator;
import org.tinygroup.template.rumtime.operator.LeftLiteralOperator;
import org.tinygroup.template.rumtime.operator.LeftNotOperator;
import org.tinygroup.template.rumtime.operator.LeftPlusPlusOperator;
import org.tinygroup.template.rumtime.operator.LeftSubtractOperator;
import org.tinygroup.template.rumtime.operator.LeftSubtractSubtractOperator;
import org.tinygroup.template.rumtime.operator.LessEqualsOperator;
import org.tinygroup.template.rumtime.operator.LessOperator;
import org.tinygroup.template.rumtime.operator.ModOperator;
import org.tinygroup.template.rumtime.operator.MultiplyOperator;
import org.tinygroup.template.rumtime.operator.NotEqualsOperator;
import org.tinygroup.template.rumtime.operator.OrLogicOperator;
import org.tinygroup.template.rumtime.operator.OrOperator;
import org.tinygroup.template.rumtime.operator.RightPlusPlusOperator;
import org.tinygroup.template.rumtime.operator.RightSubtractSubtractOperator;
import org.tinygroup.template.rumtime.operator.ShlOperator;
import org.tinygroup.template.rumtime.operator.Shr2Operator;
import org.tinygroup.template.rumtime.operator.ShrOperator;
import org.tinygroup.template.rumtime.operator.SimpleConditionOperator;
import org.tinygroup.template.rumtime.operator.SubtractOperator;
import org.tinygroup.template.rumtime.operator.XorOperator;

public final class OperationUtil {
    private static Map<String, Operator> operationMap = new HashMap<String, Operator>();
    private static Map<String, OperatorWithContext> operationWithContextMap = new HashMap<String, OperatorWithContext>();
    private static Converter[][] converters = new Converter[7][7];
    private static Map<Class, Integer> typeMap = new HashMap<Class, Integer>();

    private OperationUtil() {
    }

    public static Object convert(Object object, Class sourceType, Class destType) {
        return converters[typeMap.get(sourceType)][typeMap.get(destType)].convert(object);
    }

    public static int compare(Class type1, Class type2) {
        int index2;
        int index1 = typeMap.get(type1);
        if (index1 == (index2 = typeMap.get(type2).intValue())) {
            return 0;
        }
        if (index1 > index2) {
            return 1;
        }
        return -1;
    }

    public static boolean isNumber(Class type) {
        return typeMap.containsKey(type);
    }

    public static void addConverter(Converter converter) {
        OperationUtil.converters[OperationUtil.typeMap.get((Object)converter.getSourceType()).intValue()][OperationUtil.typeMap.get((Object)converter.getDestType()).intValue()] = converter;
    }

    public static void addOperator(Operator operator) {
        operationMap.put(operator.getOperation(), operator);
    }

    public static void addOperator(OperatorWithContext operator) {
        operationWithContextMap.put(operator.getOperation(), operator);
    }

    public static Object executeOperation(String op, Object ... parameters) throws TemplateException {
        Operator operator = operationMap.get(op);
        if (operator == null) {
            throw new TemplateException("\u627e\u4e0d\u5bf9\u5bf9\u5e94\u4e8e\uff1a" + op + "\u7684\u5904\u7406\u5668\u3002");
        }
        return operator.operation(parameters);
    }

    public static Object executeOperationWithContext(TemplateContext context, String op, String name, Object value) throws TemplateException {
        OperatorWithContext operator = operationWithContextMap.get(op);
        if (operator == null) {
            throw new TemplateException("\u627e\u4e0d\u5bf9\u5bf9\u5e94\u4e8e\uff1a" + op + "\u7684\u5904\u7406\u5668\u3002");
        }
        return operator.operation(context, name, value);
    }

    static {
        typeMap.put(Byte.class, 0);
        typeMap.put(Character.class, 1);
        typeMap.put(Integer.class, 2);
        typeMap.put(Long.class, 3);
        typeMap.put(Float.class, 4);
        typeMap.put(Double.class, 5);
        typeMap.put(BigDecimal.class, 6);
        OperationUtil.addConverter(new ByteCharacter());
        OperationUtil.addConverter(new ByteInteger());
        OperationUtil.addConverter(new ByteFloat());
        OperationUtil.addConverter(new ByteDouble());
        OperationUtil.addConverter(new ByteBigDecimal());
        OperationUtil.addConverter(new CharacterInteger());
        OperationUtil.addConverter(new CharacterFloat());
        OperationUtil.addConverter(new CharacterDouble());
        OperationUtil.addConverter(new CharacterBigDecimal());
        OperationUtil.addConverter(new IntegerLong());
        OperationUtil.addConverter(new IntegerFloat());
        OperationUtil.addConverter(new IntegerDouble());
        OperationUtil.addConverter(new IntegerBigDecimal());
        OperationUtil.addConverter(new LongFloat());
        OperationUtil.addConverter(new LongDouble());
        OperationUtil.addConverter(new LongBigDecimal());
        OperationUtil.addConverter(new FloatDouble());
        OperationUtil.addConverter(new FloatBigDecimal());
        OperationUtil.addConverter(new DoubleBigDecimal());
        OperationUtil.addOperator(new AddOperator());
        OperationUtil.addOperator(new SubtractOperator());
        OperationUtil.addOperator(new MultiplyOperator());
        OperationUtil.addOperator(new DevideOperator());
        OperationUtil.addOperator(new XorOperator());
        OperationUtil.addOperator(new AdOperator());
        OperationUtil.addOperator(new OrOperator());
        OperationUtil.addOperator(new ModOperator());
        OperationUtil.addOperator(new SimpleConditionOperator());
        OperationUtil.addOperator(new LeftAddOperator());
        OperationUtil.addOperator(new LeftSubtractOperator());
        OperationUtil.addOperator(new LeftPlusPlusOperator());
        OperationUtil.addOperator(new LeftSubtractSubtractOperator());
        OperationUtil.addOperator(new RightPlusPlusOperator());
        OperationUtil.addOperator(new RightSubtractSubtractOperator());
        OperationUtil.addOperator(new LeftLiteralOperator());
        OperationUtil.addOperator(new ComplementOperator());
        OperationUtil.addOperator(new LeftNotOperator());
        OperationUtil.addOperator(new AndLogicOperator());
        OperationUtil.addOperator(new OrLogicOperator());
        OperationUtil.addOperator(new EqualsOperator());
        OperationUtil.addOperator(new NotEqualsOperator());
        OperationUtil.addOperator(new LessEqualsOperator());
        OperationUtil.addOperator(new LessOperator());
        OperationUtil.addOperator(new BigOperator());
        OperationUtil.addOperator(new BigEqualsOperator());
        OperationUtil.addOperator(new ShlOperator());
        OperationUtil.addOperator(new ShrOperator());
        OperationUtil.addOperator(new Shr2Operator());
    }
}

