/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.rumtime;

import java.util.AbstractList;

public class RangeList
extends AbstractList<Integer> {
    private final int start;
    private final int step;
    private final int size;

    public RangeList(int start, int stop, int step) {
        this.start = start;
        this.step = step;
        this.size = (stop - start) / step + 1;
    }

    public RangeList(Object start, Object stop) {
        Number startNumber = (Number)start;
        Number endNumber = (Number)stop;
        this.start = startNumber.intValue();
        this.step = startNumber.intValue() < endNumber.intValue() ? 1 : -1;
        this.size = (endNumber.intValue() - startNumber.intValue()) / this.step + 1;
    }

    @Override
    public Integer get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.start + index * this.step;
    }

    @Override
    public int size() {
        return this.size;
    }
}

