/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.template.rumtime;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.StringUtils;
import org.tinygroup.beancontainer.BeanContainer;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Enumerator;
import org.tinygroup.context.Context;
import org.tinygroup.template.I18nVisitor;
import org.tinygroup.template.StaticClassOperator;
import org.tinygroup.template.Template;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.TemplateFunction;

public final class TemplateUtil {
    private static Map<Class, Map<String, Method>> methodCache = new HashMap<Class, Map<String, Method>>();
    private static Map<Class, Map<String, Field>> fieldCache = new HashMap<Class, Map<String, Field>>();
    private static PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
    private static String[] tabCache = new String[31];
    private static boolean safeVariable = false;
    private static BeanContainer<?> container = BeanContainerFactory.getBeanContainer((ClassLoader)TemplateUtil.class.getClassLoader());

    private TemplateUtil() {
    }

    public static boolean isSafeVariable() {
        return safeVariable;
    }

    public static void setSafeVariable(boolean safeVariable) {
        TemplateUtil.safeVariable = safeVariable;
    }

    public static Object getAttribute(Object object, Object name) throws TemplateException {
        try {
            PropertyDescriptor descriptor;
            Object value;
            if (object instanceof Map && (value = ((Map)object).get(name)) != null) {
                return value;
            }
            String fieldName = name.toString();
            Map<String, Method> stringMethodMap = methodCache.get(object.getClass());
            Method method = null;
            if (stringMethodMap != null) {
                method = stringMethodMap.get(fieldName);
            }
            if (method == null && (descriptor = propertyUtilsBean.getPropertyDescriptor(object, fieldName)) != null && descriptor.getReadMethod() != null) {
                method = object.getClass().getMethod(descriptor.getReadMethod().getName(), new Class[0]);
                method.setAccessible(true);
                if (stringMethodMap == null) {
                    stringMethodMap = new HashMap<String, Method>();
                    methodCache.put(object.getClass(), stringMethodMap);
                }
                stringMethodMap.put(fieldName, method);
            }
            if (method != null) {
                return method.invoke(object, new Object[0]);
            }
            Map<String, Field> stringFieldMap = fieldCache.get(fieldName);
            Field field = null;
            if (stringFieldMap != null) {
                field = stringFieldMap.get(fieldName);
            }
            if (field == null && (field = object.getClass().getField(fieldName)) != null) {
                if ((field.getModifiers() & 1) == 1) {
                    field.setAccessible(true);
                    if (stringFieldMap == null) {
                        stringFieldMap = new HashMap<String, Field>();
                        fieldCache.put(object.getClass(), stringFieldMap);
                    }
                    stringFieldMap.put(fieldName, field);
                } else {
                    field = null;
                }
            }
            if (field != null) {
                return field.get(object);
            }
            throw new TemplateException(object.getClass().getName() + "\u4e2d\u4e0d\u80fd\u627e\u5230" + fieldName + "\u7684\u952e\u503c\u3001\u5c5e\u6027\u3002");
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    public static Object sp(Object object, Object name) throws TemplateException {
        if (object != null) {
            try {
                return TemplateUtil.getAttribute(object, name);
            }
            catch (TemplateException e) {
                if (e.getCause().getClass() == NullPointerException.class || e.getCause().getClass() == NoSuchFieldException.class || e.getMessage().indexOf("\u4e2d\u4e0d\u80fd\u627e\u5230") > -1) {
                    return null;
                }
                throw e;
            }
        }
        return null;
    }

    public static String getI18n(I18nVisitor i18nVistor, TemplateContext context, String key) {
        if (key == null) {
            return null;
        }
        if (i18nVistor == null) {
            return key;
        }
        return i18nVistor.getI18nMessage(context, key);
    }

    public static Object callMethod(Template template, TemplateContext context, Object object, String methodName, Object ... parameters) throws TemplateException {
        try {
            TemplateFunction function = template.getTemplateEngine().getTemplateFunction(object, methodName);
            if (function != null) {
                return TemplateUtil.executeExtendFunction(template, context, object, function, parameters);
            }
            return TemplateUtil.executeClassMethod(object, methodName, parameters);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException e1 = (InvocationTargetException)e;
                throw new TemplateException(e1.getTargetException());
            }
            throw new TemplateException(e);
        }
    }

    public static Object executeClassMethod(Object object, String methodName, Object[] parameters) throws Exception {
        Method method = TemplateUtil.getMethodByName(object, methodName, parameters);
        if (method != null) {
            return method.invoke(object, parameters);
        }
        if (object instanceof StaticClassOperator) {
            return ((StaticClassOperator)object).invokeStaticMethod(methodName, parameters);
        }
        return MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])parameters);
    }

    private static Method getMethodByName(Object object, String methodName, Object[] parameters) {
        Method method = null;
        Map<String, Method> stringMethodMap = methodCache.get(object.getClass());
        if (stringMethodMap != null) {
            method = stringMethodMap.get(methodName);
        }
        if (method == null) {
            List<Method> methods = TemplateUtil.getMethodList(object.getClass(), methodName);
            if (methods.size() == 1) {
                method = methods.get(0);
                if (stringMethodMap == null) {
                    stringMethodMap = new HashMap<String, Method>();
                    methodCache.put(object.getClass(), stringMethodMap);
                }
                stringMethodMap.put(methodName, method);
            } else {
                int length = parameters == null ? 0 : parameters.length;
                for (Method method1 : methods) {
                    int length1;
                    int n = length1 = method1.getParameterTypes() == null ? 0 : method1.getParameterTypes().length;
                    if (length1 != length) continue;
                    int count = 0;
                    for (int i = 0; i < length1; ++i) {
                        if (parameters[i] != null && !parameters[i].getClass().equals(method1.getParameterTypes()[i].getClass())) continue;
                        ++count;
                    }
                    if (count != length1) continue;
                    return method1;
                }
            }
        }
        return method;
    }

    private static List<Method> getMethodList(Class clz, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            methods.add(method);
        }
        return methods;
    }

    private static Object executeExtendFunction(Template template, TemplateContext context, Object object, TemplateFunction function, Object[] parameters) throws TemplateException {
        Object[] newParameters = new Object[(parameters == null ? 1 : parameters.length) + 1];
        newParameters[0] = object;
        if (parameters != null && parameters.length > 0) {
            System.arraycopy(parameters, 0, newParameters, 1, parameters.length);
        }
        return function.execute(template, context, newParameters);
    }

    public static Object safeCallMethod(Template template, TemplateContext context, Object object, String methodName, Object ... parameters) throws TemplateException {
        if (object != null) {
            try {
                return TemplateUtil.callMethod(template, context, object, methodName, parameters);
            }
            catch (TemplateException e) {
                if (e.getCause() != null && e.getCause().getClass() == NoSuchMethodException.class) {
                    return null;
                }
                throw e;
            }
        }
        return null;
    }

    public static Class<?>[] getParameterTypes(Class clazz, String methodName) throws TemplateException {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method.getParameterTypes();
        }
        throw new TemplateException(clazz.getName() + "\u4e2d\u627e\u4e0d\u5230\u65b9\u6cd5:" + methodName);
    }

    public static Object getValueFromContext(Context context, Object key) {
        return context.get(key.toString());
    }

    public static Object getValueFromBean(Object key) {
        try {
            return container.getBean(key.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getVariableValue(Context context, Object key) {
        Object value = TemplateUtil.getValueFromContext(context, key);
        if (value == null) {
            value = TemplateUtil.getValueFromBean(key);
        }
        return value;
    }

    public static String getPath(String currentPath, String newPath) {
        String path = newPath;
        URI uri = URI.create(currentPath);
        path = path.replaceAll("[\\\\]", "/");
        URI newUri = uri.resolve(path);
        return newUri.getPath();
    }

    public static void dent(TemplateContext context) {
        Boolean compactMode = (Boolean)context.get("$compactMode");
        if (compactMode != null && compactMode.booleanValue()) {
            return;
        }
        Integer tab = (Integer)context.get("$tab");
        if (tab != null) {
            context.put("$tab", tab + 1);
        } else {
            context.put("$tab", 1);
        }
    }

    public static void indent(TemplateContext context) {
        Boolean compactMode = (Boolean)context.get("$compactMode");
        if (compactMode != null && compactMode.booleanValue()) {
            return;
        }
        Integer tab = (Integer)context.get("$tab");
        if (tab != null) {
            context.put("$tab", tab - 1);
        } else {
            context.put("$tab", 0);
        }
    }

    public static String getBlanks(TemplateContext context) {
        Boolean compactMode = (Boolean)context.get("$compactMode");
        if (compactMode != null && compactMode.booleanValue()) {
            return null;
        }
        Integer tab = (Integer)context.get("$tab");
        if (tab != null) {
            if (tab < tabCache.length) {
                return tabCache[tab];
            }
            return tabCache[tabCache.length - 1];
        }
        return null;
    }

    public static String escapeHtml(Object object) {
        if (object == null) {
            return null;
        }
        return StringUtils.replaceEach((String)object.toString(), (String[])new String[]{"&", "\"", "<", ">"}, (String[])new String[]{"&amp;", "&quot;", "&lt;", "&gt;"});
    }

    public static boolean getBooleanValue(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() == Boolean.class) {
            return (Boolean)object;
        }
        if (object.getClass() == String.class) {
            return ((String)object).length() > 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() > 0;
        }
        if (object.getClass().isArray()) {
            return ArrayUtil.arrayLength((Object)object) > 0;
        }
        if (object instanceof Iterator) {
            return ((Iterator)object).hasNext();
        }
        if (object instanceof Enumerator) {
            Enumerator e = (Enumerator)object;
            return e.hasMoreElements();
        }
        if (object instanceof Map) {
            Map e = (Map)object;
            return e.size() > 0;
        }
        return true;
    }

    public static Object getSafeArrayValue(Object object, Object indexObject) throws TemplateException {
        if (object == null) {
            return null;
        }
        try {
            return TemplateUtil.getArrayValue(object, indexObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getArrayValue(Object object, Object indexObject) throws TemplateException {
        try {
            if (object instanceof Map) {
                Map map = (Map)object;
                return map.get(indexObject);
            }
            int index = indexObject instanceof Integer ? (Integer)indexObject : (indexObject instanceof Long ? ((Long)indexObject).intValue() : (indexObject instanceof Double ? ((Double)indexObject).intValue() : (indexObject instanceof Float ? ((Float)indexObject).intValue() : (indexObject instanceof Byte ? ((Byte)indexObject).intValue() : (indexObject instanceof BigDecimal ? ((BigDecimal)indexObject).intValue() : Integer.parseInt(indexObject.toString()))))));
            if (object.getClass().isArray()) {
                return Array.get(object, index);
            }
            if (object instanceof Collection) {
                Collection c = (Collection)object;
                Iterator it = c.iterator();
                for (int i = 0; i < c.size(); ++i) {
                    Object o = it.next();
                    if (i != index) continue;
                    return o;
                }
                return null;
            }
            String o = object.toString();
            return Character.valueOf(o.charAt(index));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("%s\u901a\u8fc7\u4e0b\u6807%s\u53d6\u503c\u53d1\u751f\u5f02\u5e38\uff1a", object.getClass().getName(), indexObject.toString()), e);
        }
    }

    public static String getLocalePath(String path, Locale locale) {
        if (locale != null) {
            int pos = path.lastIndexOf(".");
            String localePath = path.substring(0, pos) + "_" + locale.getLanguage() + "_" + locale.getCountry() + path.substring(pos);
            return localePath;
        }
        return path;
    }

    public static String trimStart(String str, String[] stripChars) {
        int strLen;
        if (stripChars == null || stripChars.length == 0) {
            return str;
        }
        if (str != null && (strLen = str.length()) != 0) {
            int start;
            for (start = 0; start < strLen && TemplateUtil.isStripChar(str.charAt(start), stripChars); ++start) {
            }
            return str.substring(start);
        }
        return str;
    }

    public static String trimEnd(String str, String[] stripChars) {
        int end;
        if (str != null && (end = str.length()) != 0) {
            while (end != 0 && TemplateUtil.isStripChar(str.charAt(end - 1), stripChars)) {
                --end;
            }
            return str.substring(0, end);
        }
        return str;
    }

    private static boolean isStripChar(char charStr, String[] stripChars) {
        for (int i = 0; i < stripChars.length; ++i) {
            if (stripChars[i].indexOf(charStr) == -1) continue;
            return true;
        }
        return false;
    }

    static {
        TemplateUtil.tabCache[0] = "";
        for (int i = 1; i < tabCache.length; ++i) {
            TemplateUtil.tabCache[i] = String.format("%" + i * 4 + "s", "");
        }
    }
}

