/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templateindex.impl;

import java.util.List;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.fulltext.FullTextHelper;
import org.tinygroup.fulltext.document.DefaultDocument;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.fulltext.exception.FullTextException;
import org.tinygroup.fulltext.field.Field;
import org.tinygroup.fulltext.field.StringField;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.impl.TemplateContextDefault;
import org.tinygroup.templateindex.config.IndexFieldConfig;
import org.tinygroup.templateindex.impl.AbstractTemplateIndexRender;

public class DynamicDocumentCreator
extends AbstractTemplateIndexRender {
    private List<IndexFieldConfig> fieldConfigs;

    public DynamicDocumentCreator() {
    }

    public DynamicDocumentCreator(List<IndexFieldConfig> indexFieldConfigs) {
        this.fieldConfigs = indexFieldConfigs;
    }

    @Override
    public Document execute(Context context) {
        TemplateContextDefault templateContext = new TemplateContextDefault();
        templateContext.setParent(context);
        DefaultDocument document = new DefaultDocument();
        try {
            if (this.fieldConfigs != null) {
                for (IndexFieldConfig fieldConfig : this.fieldConfigs) {
                    String value = this.getTemplateRender().renderTemplateContent(fieldConfig.getTemplateRule(), (TemplateContext)templateContext);
                    document.addField(this.createField(fieldConfig, value));
                }
            }
        }
        catch (Exception e) {
            throw new FullTextException((Throwable)e);
        }
        finally {
            templateContext.setParent(null);
        }
        return document;
    }

    private Field createField(IndexFieldConfig fieldConfig, String value) {
        boolean indexed = this.getSafeBoolean(fieldConfig.getIndexed(), true);
        boolean stored = this.getSafeBoolean(fieldConfig.getStored(), true);
        String name = fieldConfig.getIndexName();
        boolean tokenized = FullTextHelper.getStoreId().equals(name) || FullTextHelper.getStoreType().equals(name) ? this.getSafeBoolean(fieldConfig.getTokenized(), false) : this.getSafeBoolean(fieldConfig.getTokenized(), true);
        return new StringField(name, value, indexed, stored, tokenized);
    }

    private boolean getSafeBoolean(String str, boolean tag) {
        if (StringUtil.isEmpty((String)str)) {
            return tag;
        }
        return Boolean.parseBoolean(str);
    }
}

