/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templateindex.impl;

import java.util.Map;
import org.tinygroup.context.Context;
import org.tinygroup.fulltext.FullTextHelper;
import org.tinygroup.fulltext.document.DefaultDocument;
import org.tinygroup.fulltext.document.Document;
import org.tinygroup.fulltext.exception.FullTextException;
import org.tinygroup.fulltext.field.Field;
import org.tinygroup.fulltext.field.StringField;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateException;
import org.tinygroup.template.impl.TemplateContextDefault;
import org.tinygroup.templateindex.impl.AbstractTemplateIndexRender;

public class TemplateDocumentCreator
extends AbstractTemplateIndexRender {
    private String idRule;
    private String typeRule;
    private String titleRule;
    private String abstractRule;
    private boolean initTag = false;

    public TemplateDocumentCreator() {
    }

    public TemplateDocumentCreator(String idRule, String typeRule, String titleRule, String abstractRule) {
        this.idRule = idRule;
        this.typeRule = typeRule;
        this.titleRule = titleRule;
        this.abstractRule = abstractRule;
    }

    public String getIdRule() {
        return this.idRule;
    }

    public void setIdRule(String idRule) {
        this.idRule = idRule;
    }

    public String getTypeRule() {
        return this.typeRule;
    }

    public void setTypeRule(String typeRule) {
        this.typeRule = typeRule;
    }

    public String getTitleRule() {
        return this.titleRule;
    }

    public void setTitleRule(String titleRule) {
        this.titleRule = titleRule;
    }

    public String getAbstractRule() {
        return this.abstractRule;
    }

    public void setAbstractRule(String abstractRule) {
        this.abstractRule = abstractRule;
    }

    @Override
    public Document execute(Context context) {
        if (!this.initTag) {
            this.addTemplate(this.idRule);
            this.addTemplate(this.typeRule);
            this.addTemplate(this.titleRule);
            this.addTemplate(this.abstractRule);
            this.initTag = true;
        }
        TemplateContextDefault templateContext = new TemplateContextDefault();
        templateContext.setParent(context);
        DefaultDocument document = new DefaultDocument();
        try {
            document.addField(this.renderId((TemplateContext)templateContext));
            document.addField(this.renderType((TemplateContext)templateContext));
            document.addField(this.renderTitle((TemplateContext)templateContext));
            document.addField(this.renderAbstarctRule((TemplateContext)templateContext));
            for (Map.Entry entry : context.getItemMap().entrySet()) {
                String s = (String)entry.getKey();
                if (s.equals(FullTextHelper.getStoreId()) || s.equals(FullTextHelper.getStoreType()) || s.equals(FullTextHelper.getStoreTitle()) || s.equals(FullTextHelper.getStoreAbstract())) continue;
                document.addField((Field)new StringField((String)entry.getKey(), entry.getValue().toString(), true, true, true));
            }
        }
        catch (Exception e) {
            throw new FullTextException((Throwable)e);
        }
        finally {
            templateContext.setParent(null);
        }
        return document;
    }

    protected Field renderId(TemplateContext templateContext) throws TemplateException {
        String value = this.getTemplateRender().renderTemplateWithOutLayout(this.idRule, templateContext);
        return new StringField(FullTextHelper.getStoreId(), value);
    }

    protected Field renderType(TemplateContext templateContext) throws TemplateException {
        String value = this.getTemplateRender().renderTemplateWithOutLayout(this.typeRule, templateContext);
        return new StringField(FullTextHelper.getStoreType(), value);
    }

    protected Field renderTitle(TemplateContext templateContext) throws TemplateException {
        String value = this.getTemplateRender().renderTemplateWithOutLayout(this.titleRule, templateContext);
        return new StringField(FullTextHelper.getStoreTitle(), value, true, true, true);
    }

    protected Field renderAbstarctRule(TemplateContext templateContext) throws TemplateException {
        String value = this.getTemplateRender().renderTemplateWithOutLayout(this.abstractRule, templateContext);
        return new StringField(FullTextHelper.getStoreAbstract(), value, true, true, true);
    }
}

