/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.templatespringext.FileProcessor;
import org.tinygroup.templatespringext.FileScanner;
import org.tinygroup.vfs.FileObject;

public abstract class AbstractFileScanner
implements FileScanner {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileScanner.class);
    private List<String> classPathList = new ArrayList<String>();
    private List<FileProcessor> fileProcessors = new ArrayList<FileProcessor>();

    public List<FileProcessor> getFileProcessors() {
        return this.fileProcessors;
    }

    public void setFileProcessors(List<FileProcessor> fileProcessors) {
        this.fileProcessors = fileProcessors;
    }

    protected List<String> getClassPathList() {
        return this.classPathList;
    }

    @Override
    public void setClassPathList(List<String> classPathList) {
        this.classPathList = classPathList;
    }

    @Override
    public void resolverFolder(FileObject file) {
        if (file.isFolder()) {
            for (FileProcessor fileProcessor : this.fileProcessors) {
                if (!fileProcessor.isMatch(file.getFileName())) continue;
                fileProcessor.addFile(file);
            }
            for (FileObject f : file.getChildren()) {
                this.resolverFolder(f);
            }
        } else {
            for (FileProcessor fileProcessor : this.fileProcessors) {
                if (!fileProcessor.isMatch(file.getFileName())) continue;
                fileProcessor.addFile(file);
            }
        }
    }
}

