/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.impl;

import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.loader.FileObjectResourceLoader;
import org.tinygroup.template.loader.FileResourceManager;
import org.tinygroup.templatespringext.AbstractFileScanner;
import org.tinygroup.templatespringext.processor.TinyJarFileProcessor;
import org.tinygroup.templatespringext.processor.TinyLocalPathProcessor;
import org.tinygroup.templatespringext.processor.TinyMacroProcessor;
import org.tinygroup.vfs.VFS;

public class FileScannerImpl
extends AbstractFileScanner {
    private TinyJarFileProcessor jarFileProcessor;
    private TinyMacroProcessor macroFileProcessor;
    private TinyLocalPathProcessor localPathProcessor;
    private TemplateEngine engine;
    private FileResourceManager fileResourceManager = new FileResourceManager();

    @Override
    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    public TinyJarFileProcessor getJarFileProcessor() {
        return this.jarFileProcessor;
    }

    public void setJarFileProcessor(TinyJarFileProcessor jarFileProcessor) {
        this.jarFileProcessor = jarFileProcessor;
    }

    @Override
    public void init() {
        this.jarFileProcessor = this.jarFileProcessor == null ? new TinyJarFileProcessor() : this.jarFileProcessor;
        this.jarFileProcessor.setFileResourceManager(this.fileResourceManager);
        this.macroFileProcessor = new TinyMacroProcessor();
        this.macroFileProcessor.setFileResourceManager(this.fileResourceManager);
        this.localPathProcessor = new TinyLocalPathProcessor();
        this.localPathProcessor.setFileResourceManager(this.fileResourceManager);
        FileObjectResourceLoader fileObjectResourceLoader = new FileObjectResourceLoader("page", "layout", "component");
        fileObjectResourceLoader.setFileResourceManager(this.fileResourceManager);
        this.engine.addResourceLoader((ResourceLoader)fileObjectResourceLoader);
        this.getFileProcessors().add(this.jarFileProcessor);
        this.getFileProcessors().add(this.macroFileProcessor);
        this.getFileProcessors().add(this.localPathProcessor);
        this.jarFileProcessor.setEngine(this.engine);
        this.macroFileProcessor.setEngine(this.engine);
        this.localPathProcessor.setEngine(this.engine);
    }

    @Override
    public void scanFile() {
        this.resolverFolder(VFS.resolveFile((String)"./"));
    }

    @Override
    public void fileProcess() {
        this.localPathProcessor.process();
        this.classPathProcess();
        this.jarFileProcessor.process();
        this.macroFileProcessor.process();
    }

    @Override
    public void classPathProcess() {
        for (String classPath : this.getClassPathList()) {
            this.fileResourceManager.addResources(this.engine, classPath, ".page", ".layout", ".component");
        }
    }
}

