/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.processor;

import java.util.List;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.templatespringext.AbstractFileProcessor;
import org.tinygroup.vfs.FileObject;

public class TinyJarFileProcessor
extends AbstractFileProcessor {
    private static final String JAR_FILE_EXT = ".jar";
    private TemplateEngine engine;
    private List<String> nameRule;

    public List<String> getNameRule() {
        return this.nameRule;
    }

    public void setNameRule(List<String> nameRule) {
        this.nameRule = nameRule;
    }

    public TemplateEngine getEngine() {
        return this.engine;
    }

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    @Override
    public boolean isMatch(String fileName) {
        return fileName.endsWith(JAR_FILE_EXT) && this.jarNameMatches(fileName);
    }

    public boolean jarNameMatches(String fileName) {
        for (String rule : this.nameRule) {
            if (!fileName.matches(rule)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process() {
        if (this.fileList.size() > 0) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7dJar\u6587\u4ef6...");
            for (FileObject file : this.fileList) {
                this.getFileResourceManager().addResources(this.engine, file, ".page", ".layout", ".component");
            }
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dJar\u6587\u4ef6\u7ed3\u675f...");
        }
    }
}

