/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.processor;

import org.tinygroup.logger.LogLevel;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.templatespringext.AbstractFileProcessor;
import org.tinygroup.vfs.FileObject;

public class TinyLocalPathProcessor
extends AbstractFileProcessor {
    private static final String CLASSES_FILE_EXT = "classes";
    private static final String RESOURCE_FILE_EXT = "resources";
    private static final String WEB_INF_FILE_EXT = "WEB-INF";
    private TemplateEngine engine;

    public TemplateEngine getEngine() {
        return this.engine;
    }

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    @Override
    public boolean isMatch(String fileName) {
        return fileName.equals(CLASSES_FILE_EXT) || fileName.equals(RESOURCE_FILE_EXT) || fileName.equals(WEB_INF_FILE_EXT);
    }

    @Override
    public void process() {
        if (this.fileList.size() > 0) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7dPath\u8def\u5f84...");
            for (FileObject file : this.fileList) {
                this.getFileResourceManager().addResources(this.engine, file, ".page", ".layout", ".component");
            }
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dPath\u8def\u5f84\u7ed3\u675f...");
        }
    }
}

